/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.withid;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EContinue;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.tree.withid.ITreeItemWithID;
import com.helger.tree.withid.ITreeItemWithIDFactory;
import com.helger.tree.withid.ITreeWithID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
implements ITreeWithID<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRootItem;

    public BasicTreeWithID(@NonNull ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithIDFactory) {
        ValueEnforcer.notNull(iTreeItemWithIDFactory, (String)"Factory");
        this.m_aRootItem = iTreeItemWithIDFactory.createRoot();
        if (this.m_aRootItem == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
        if (this.m_aRootItem.getParent() != null) {
            throw new IllegalStateException("Create root item has a non-null parent!!!");
        }
    }

    public final boolean hasChildren() {
        return true;
    }

    @Nonnegative
    public final int getChildCount() {
        return 1;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsCollection<ITEMTYPE> getAllChildren() {
        return new CommonsArrayList(this.m_aRootItem);
    }

    public final @NonNull ICommonsIterable<ITEMTYPE> getChildren() {
        return this.getAllChildren();
    }

    public final void forAllChildren(@NonNull Consumer<? super ITEMTYPE> consumer) {
        consumer.accept(this.m_aRootItem);
    }

    public final @NonNull EContinue forAllChildrenBreakable(@NonNull Function<? super ITEMTYPE, EContinue> function) {
        return function.apply(this.m_aRootItem);
    }

    public final void forAllChildren(@NonNull Predicate<? super ITEMTYPE> predicate, @NonNull Consumer<? super ITEMTYPE> consumer) {
        if (predicate.test(this.m_aRootItem)) {
            consumer.accept(this.m_aRootItem);
        }
    }

    public final <DSTTYPE> void forAllChildrenMapped(@NonNull Predicate<? super ITEMTYPE> predicate, @NonNull Function<? super ITEMTYPE, ? extends DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
        if (predicate.test(this.m_aRootItem)) {
            consumer.accept(function.apply(this.m_aRootItem));
        }
    }

    @Override
    public final @NonNull ITEMTYPE getRootItem() {
        return this.m_aRootItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTreeWithID basicTreeWithID = (BasicTreeWithID)object;
        return this.m_aRootItem.equals(basicTreeWithID.m_aRootItem);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aRootItem).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("root", this.m_aRootItem).getToString();
    }
}

