/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.sort;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.hierarchy.IHasChildren;
import com.helger.collection.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.tree.IBasicTree;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.ITreeItem;
import java.util.Comparator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class TreeSorter {
    private static final TreeSorter INSTANCE = new TreeSorter();

    private TreeSorter() {
    }

    private static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void _sort(@NonNull IBasicTree<? extends DATATYPE, ITEMTYPE> iBasicTree, final @NonNull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        ChildrenProviderHierarchyVisitor.visitFrom((IHasChildren)((ITreeItem)iBasicTree.getRootItem()), (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            public @NonNull EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildItems(comparator);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        }, (boolean)true);
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@NonNull IBasicTree<? extends DATATYPE, ITEMTYPE> iBasicTree, @NonNull Comparator<? super DATATYPE> comparator) {
        TreeSorter._sort(iBasicTree, Comparator.comparing(IBasicTreeItem::getData, comparator));
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        TreeSorter._sort(iBasicTree, (iTreeItem, iTreeItem2) -> ((Comparable)iTreeItem.getData()).compareTo(iTreeItem2.getData()));
    }
}

