/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.state.ESuccess;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.ITreeItem;
import com.helger.tree.ITreeItemFactory;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class BasicTreeItem<DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>>
implements ITreeItem<DATATYPE, ITEMTYPE> {
    private final ITreeItemFactory<DATATYPE, ITEMTYPE> m_aFactory;
    private ITEMTYPE m_aParent;
    private DATATYPE m_aData;
    private ICommonsList<ITEMTYPE> m_aChildren;

    public BasicTreeItem(@NonNull ITreeItemFactory<DATATYPE, ITEMTYPE> iTreeItemFactory) {
        this.m_aFactory = (ITreeItemFactory)ValueEnforcer.notNull(iTreeItemFactory, (String)"Factory");
        this.m_aParent = null;
        this.m_aData = null;
    }

    public BasicTreeItem(@NonNull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"Parent");
        ValueEnforcer.isTrue((boolean)(ITEMTYPE instanceof BasicTreeItem), (String)"Parent is no BasicTreeItem");
        ValueEnforcer.notNull(ITEMTYPE.getFactory(), (String)"parent item factory");
        this.m_aParent = ITEMTYPE;
        this.m_aFactory = ITEMTYPE.getFactory();
        this.m_aData = null;
    }

    @Override
    public final @NonNull ITreeItemFactory<DATATYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @OverrideOnDemand
    protected boolean isValidData(DATATYPE DATATYPE) {
        return true;
    }

    @Override
    public final @Nullable DATATYPE getData() {
        return this.m_aData;
    }

    @Override
    public final void setData(@Nullable DATATYPE DATATYPE) {
        ValueEnforcer.isTrue((boolean)this.isValidData(DATATYPE), (String)"The passed data object is invalid!");
        this.m_aData = DATATYPE;
    }

    @Override
    public final boolean isRootItem() {
        return this.m_aParent == null;
    }

    public final @Nullable ITEMTYPE getParent() {
        return this.m_aParent;
    }

    @Override
    public final @Nullable DATATYPE getParentData() {
        return this.m_aParent == null ? null : (DATATYPE)this.m_aParent.getData();
    }

    @Override
    @Nonnegative
    public final int getLevel() {
        int n = 0;
        ITreeItem iTreeItem = (ITreeItem)this.thisAsT();
        while (iTreeItem.getParent() != null) {
            ++n;
            iTreeItem = (ITreeItem)iTreeItem.getParent();
        }
        return n;
    }

    @Override
    public final @NonNull ITEMTYPE createChildItem(@Nullable DATATYPE DATATYPE) {
        ITreeItem iTreeItem = this.m_aFactory.create((ITreeItem)this.thisAsT());
        if (iTreeItem == null) {
            throw new IllegalStateException("null item created!");
        }
        iTreeItem.setData(DATATYPE);
        this.internalAddChild(iTreeItem);
        return (ITEMTYPE)iTreeItem;
    }

    public final boolean hasChildren() {
        return this.m_aChildren != null && this.m_aChildren.isNotEmpty();
    }

    @ReturnsMutableCopy
    public final @Nullable ICommonsList<ITEMTYPE> getAllChildren() {
        return this.m_aChildren == null ? null : (ICommonsList)this.m_aChildren.getClone();
    }

    public final @Nullable ICommonsIterable<ITEMTYPE> getChildren() {
        return this.m_aChildren;
    }

    public final void forAllChildren(@NonNull Consumer<? super ITEMTYPE> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.forEach(consumer);
        }
    }

    public final @NonNull EContinue forAllChildrenBreakable(@NonNull Function<? super ITEMTYPE, EContinue> function) {
        if (this.m_aChildren != null) {
            return this.m_aChildren.forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    public final void forAllChildren(@NonNull Predicate<? super ITEMTYPE> predicate, @NonNull Consumer<? super ITEMTYPE> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.findAll(predicate, consumer);
        }
    }

    public final <DSTTYPE> void forAllChildrenMapped(@NonNull Predicate<? super ITEMTYPE> predicate, @NonNull Function<? super ITEMTYPE, ? extends DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.findAllMapped(predicate, function, consumer);
        }
    }

    @Override
    @ReturnsMutableCopy
    public final @Nullable ICommonsList<DATATYPE> getAllChildDatas() {
        if (this.m_aChildren == null) {
            return null;
        }
        return this.m_aChildren.getAllMapped(IBasicTreeItem::getData);
    }

    public final @Nullable ITEMTYPE getChildAtIndex(@Nonnegative int n) {
        if (this.m_aChildren == null) {
            throw new IndexOutOfBoundsException("Tree item has no children!");
        }
        return (ITEMTYPE)((ITreeItem)this.m_aChildren.get(n));
    }

    @Nonnegative
    public final int getChildCount() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.size();
    }

    public final @Nullable ITEMTYPE getFirstChild() {
        return (ITEMTYPE)(this.m_aChildren == null ? null : (ITreeItem)this.m_aChildren.getFirstOrNull());
    }

    public final @Nullable ITEMTYPE findFirstChild(@NonNull Predicate<? super ITEMTYPE> predicate) {
        return (ITEMTYPE)(this.m_aChildren == null ? null : (ITreeItem)this.m_aChildren.findFirst(predicate));
    }

    public final <DSTTYPE> @Nullable DSTTYPE findFirstChildMapped(@NonNull Predicate<? super ITEMTYPE> predicate, @NonNull Function<? super ITEMTYPE, ? extends DSTTYPE> function) {
        return (DSTTYPE)(this.m_aChildren == null ? null : this.m_aChildren.findFirstMapped(predicate, function));
    }

    public final @Nullable ITEMTYPE getLastChild() {
        return (ITEMTYPE)(this.m_aChildren == null ? null : (ITreeItem)this.m_aChildren.getLastOrNull());
    }

    @Override
    public final boolean isSameOrChildOf(@NonNull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"Parent");
        for (ITreeItem<DATATYPE, ITEMTYPE> iTreeItem = this; iTreeItem != null; iTreeItem = (ITreeItem)iTreeItem.getParent()) {
            if (!EqualsHelper.identityEqual((Object)iTreeItem, ITEMTYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final @NonNull ESuccess changeParent(@NonNull ITEMTYPE iTreeItem) {
        ValueEnforcer.notNull(iTreeItem, (String)"NewParent");
        if (this.getParent() == iTreeItem) {
            return ESuccess.SUCCESS;
        }
        ITreeItem iTreeItem2 = (ITreeItem)this.thisAsT();
        if (iTreeItem.isSameOrChildOf((ITreeItem)iTreeItem2)) {
            return ESuccess.FAILURE;
        }
        if (this.getParent().removeChild(iTreeItem2).isUnchanged()) {
            throw new IllegalStateException("Failed to remove this from parent!");
        }
        this.m_aParent = iTreeItem;
        return ESuccess.valueOfChange((IChangeIndicator)iTreeItem.internalAddChild((ITreeItem)iTreeItem2));
    }

    @Override
    public final @NonNull EChange internalAddChild(@NonNull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"Child");
        if (this.m_aChildren == null) {
            this.m_aChildren = new CommonsArrayList();
        }
        return this.m_aChildren.addObject(ITEMTYPE);
    }

    @Override
    public final @NonNull EChange removeChild(@NonNull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"Child");
        if (this.m_aChildren == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aChildren.removeObject(ITEMTYPE);
    }

    @Override
    public final void reorderChildItems(@NonNull Comparator<? super ITEMTYPE> comparator) {
        if (this.m_aChildren != null) {
            this.m_aChildren.sort(comparator);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTreeItem basicTreeItem = (BasicTreeItem)object;
        DATATYPE DATATYPE = this.m_aData;
        ICommonsList<ITEMTYPE> iCommonsList = this.m_aChildren;
        return EqualsHelper.equals(DATATYPE, basicTreeItem.m_aData) && EqualsHelper.equals(iCommonsList, basicTreeItem.m_aChildren);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aData).append(this.m_aChildren).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("data", this.m_aData).append("children", this.m_aChildren).getToString();
    }
}

