/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.xml;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.tree.xml.IConverterTreeXML;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public final class MicroTypeConverterTreeXML<DATATYPE>
implements IConverterTreeXML<DATATYPE> {
    private String m_sNamespaceURI;
    private final String m_sElementName;
    private final Class<? extends DATATYPE> m_aNativeClass;

    public MicroTypeConverterTreeXML(@Nonnull @Nonempty String string, @Nonnull Class<? extends DATATYPE> clazz) {
        this(null, string, clazz);
    }

    public MicroTypeConverterTreeXML(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull Class<? extends DATATYPE> clazz) {
        this.m_sNamespaceURI = string;
        this.m_sElementName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"ElementName");
        this.m_aNativeClass = (Class)ValueEnforcer.notNull(clazz, (String)"NativeClass");
    }

    @Override
    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Nonnull
    @Nonempty
    public String getElementName() {
        return this.m_sElementName;
    }

    @Nonnull
    public Class<? extends DATATYPE> getNativeClass() {
        return this.m_aNativeClass;
    }

    @Override
    public void appendDataValue(@Nonnull IMicroElement iMicroElement, @Nullable DATATYPE DATATYPE) {
        IMicroElement iMicroElement2 = MicroTypeConverter.convertToMicroElement(DATATYPE, (String)this.m_sNamespaceURI, (String)this.m_sElementName);
        iMicroElement.addChild((IMicroNode)iMicroElement2);
    }

    @Override
    @Nullable
    public DATATYPE getAsDataValue(@Nonnull IMicroElement iMicroElement) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement();
        if (iMicroElement2 != null) {
            String string = this.m_sNamespaceURI;
            if (!EqualsHelper.equals((Object)string, (Object)iMicroElement2.getNamespaceURI())) {
                throw new IllegalStateException("Namespace mismatch! Expected: " + this.m_sNamespaceURI);
            }
            if (!this.m_sElementName.equals(iMicroElement2.getTagName())) {
                throw new IllegalStateException("Tag name mismatch! Expected: " + this.m_sElementName);
            }
        }
        return (DATATYPE)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement2, this.m_aNativeClass);
    }

    @Nonnull
    public static <DATATYPE> MicroTypeConverterTreeXML<DATATYPE> create(@Nonnull @Nonempty String string, @Nonnull Class<? extends DATATYPE> clazz) {
        return new MicroTypeConverterTreeXML<DATATYPE>(string, clazz);
    }

    @Nonnull
    public static <DATATYPE> MicroTypeConverterTreeXML<DATATYPE> create(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull Class<? extends DATATYPE> clazz) {
        return new MicroTypeConverterTreeXML<DATATYPE>(string, string2, clazz);
    }
}

