/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.tree.IBasicTree;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.ITreeItemWithID;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class TreeWithIDSearcher {
    private static final TreeWithIDSearcher INSTANCE = new TreeWithIDSearcher();

    private TreeWithIDSearcher() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> ICommonsList<ITEMTYPE> findAllItemsWithIDRecursive(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nullable KEYTYPE KEYTYPE) {
        return TreeWithIDSearcher.findAllItemsWithIDRecursive((ITreeItemWithID)iBasicTree.getRootItem(), KEYTYPE);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> ICommonsList<ITEMTYPE> findAllItemsWithIDRecursive(@Nonnull ITEMTYPE ITEMTYPE, final @Nullable KEYTYPE KEYTYPE) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        TreeVisitor.visitTreeItem(ITEMTYPE, new DefaultHierarchyVisitorCallback<ITEMTYPE>((ICommonsList)commonsArrayList){
            final /* synthetic */ ICommonsList val$aRetList;
            {
                this.val$aRetList = iCommonsList;
            }

            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null && ITEMTYPE.getID().equals(KEYTYPE)) {
                    this.val$aRetList.add(ITEMTYPE);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
        return commonsArrayList;
    }
}

