/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resolve;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.lang.EnumHelper;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.text.IHasText;
import com.helger.text.resolve.IEnumTextResolver;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public abstract class AbstractEnumTextResolverWithOverrideAndFallback
implements IEnumTextResolver {
    public static final boolean DEFAULT_CHECK_FOR_OVERRIDE = true;
    public static final boolean DEFAULT_CHECK_FOR_FALLBACK = true;
    private static final IMutableStatisticsHandlerKeyedCounter STATS_GET_TEXT = StatisticsManager.getKeyedCounterHandler((String)(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$getText"));
    private static final IMutableStatisticsHandlerCounter STATS_OVERRIDE = StatisticsManager.getCounterHandler((String)(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$OVERRIDE"));
    private static final IMutableStatisticsHandlerCounter STATS_FALLBACK = StatisticsManager.getCounterHandler((String)(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$FALLBACK"));
    private boolean m_bCheckForOverride = true;
    private boolean m_bCheckForFallback = true;

    protected AbstractEnumTextResolverWithOverrideAndFallback() {
    }

    public final boolean isCheckForOverride() {
        return this.m_bCheckForOverride;
    }

    public final void setCheckForOverride(boolean bl) {
        this.m_bCheckForOverride = bl;
    }

    public final boolean isCheckForFallback() {
        return this.m_bCheckForFallback;
    }

    public final void setCheckForFallback(boolean bl) {
        this.m_bCheckForFallback = bl;
    }

    protected abstract @Nullable String internalGetOverrideString(@NonNull String var1, @NonNull Locale var2);

    protected abstract @Nullable String internalGetFallbackString(@NonNull String var1, @NonNull Locale var2);

    @Override
    public final @Nullable String getText(@NonNull Enum<?> enum_, @NonNull IHasText iHasText, @NonNull Locale locale) {
        String string;
        String string2 = EnumHelper.getEnumID(enum_);
        STATS_GET_TEXT.increment(string2);
        if (this.m_bCheckForOverride && (string = this.internalGetOverrideString(string2, locale)) != null) {
            STATS_OVERRIDE.increment();
            return string;
        }
        string = iHasText.getText(locale);
        if (string != null) {
            return string;
        }
        if (this.m_bCheckForFallback) {
            STATS_FALLBACK.increment();
            return this.internalGetFallbackString(string2, locale);
        }
        return null;
    }
}

