/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.format;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.format.AbstractFormatterString;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FormatterStringPrefixAndSuffix
extends AbstractFormatterString {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public FormatterStringPrefixAndSuffix(@NonNull String string, @NonNull String string2) {
        this.m_sPrefix = (String)ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sSuffix = (String)ValueEnforcer.notNull((Object)string2, (String)"Suffix");
    }

    public @NonNull String getPrefix() {
        return this.m_sPrefix;
    }

    public @NonNull String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public String apply(@Nullable Object object) {
        return this.m_sPrefix + this.getValueAsString(object) + this.m_sSuffix;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterStringPrefixAndSuffix formatterStringPrefixAndSuffix = (FormatterStringPrefixAndSuffix)object;
        return this.m_sPrefix.equals(formatterStringPrefixAndSuffix.m_sPrefix) && this.m_sSuffix.equals(formatterStringPrefixAndSuffix.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).append((Object)this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Prefix", (Object)this.m_sPrefix).append("Suffix", (Object)this.m_sSuffix).getToString();
    }

    public static @NonNull FormatterStringPrefixAndSuffix createPrefixOnly(@NonNull String string) {
        return new FormatterStringPrefixAndSuffix(string, "");
    }

    public static @NonNull FormatterStringPrefixAndSuffix createSuffixOnly(@NonNull String string) {
        return new FormatterStringPrefixAndSuffix("", string);
    }

    public static @NonNull FormatterStringPrefixAndSuffix createWithBrackets() {
        return new FormatterStringPrefixAndSuffix("[", "]");
    }
}

