/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.text.IMultilingualText;
import com.helger.text.MultilingualText;
import com.helger.text.locale.LocaleCache;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;

@Immutable
public final class TextHelper {
    public static final Locale DE = LocaleCache.getInstance().getLocale("de");
    public static final Locale EN = LocaleCache.getInstance().getLocale("en");
    private static final TextHelper INSTANCE = new TextHelper();

    private TextHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText create_DE(@Nonnull String string) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(DE, string);
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText create_EN(@Nonnull String string) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(EN, string);
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText create_DE_EN(@Nonnull String string, @Nonnull String string2) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(DE, string);
        multilingualText.addText(EN, string2);
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText getCopyWithLocales(@Nonnull IMultilingualText iMultilingualText, @Nonnull Collection<Locale> collection) {
        MultilingualText multilingualText = new MultilingualText();
        for (Locale locale : collection) {
            if (!iMultilingualText.texts().containsKey((Object)locale)) continue;
            multilingualText.setText(locale, iMultilingualText.getText(locale));
        }
        return multilingualText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultilingualText createMultilingualTextFromMap(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"Map");
        MultilingualText multilingualText = new MultilingualText();
        LocaleCache localeCache = LocaleCache.getInstance();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            if (string == null) continue;
            multilingualText.setText(localeCache.getLocale(entry.getKey()), string);
        }
        return multilingualText;
    }
}

