/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resourcebundle;

import com.helger.annotation.concurrent.Immutable;
import com.helger.text.resourcebundle.Utf8PropertyResourceBundle;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

@Immutable
public final class Utf8ResourceBundle {
    private static final Utf8ResourceBundle INSTANCE = new Utf8ResourceBundle();

    private Utf8ResourceBundle() {
    }

    @Nonnull
    private static ResourceBundle _createUtf8PropertyResourceBundle(@Nonnull ResourceBundle resourceBundle) {
        if (resourceBundle instanceof PropertyResourceBundle) {
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)resourceBundle;
            return new Utf8PropertyResourceBundle(propertyResourceBundle);
        }
        return resourceBundle;
    }

    @Nonnull
    public static ResourceBundle getBundle(@Nonnull String string) {
        return Utf8ResourceBundle._createUtf8PropertyResourceBundle(ResourceBundle.getBundle(string, Locale.getDefault()));
    }

    @Nonnull
    public static ResourceBundle getBundle(@Nonnull String string, @Nonnull Locale locale) {
        return Utf8ResourceBundle._createUtf8PropertyResourceBundle(ResourceBundle.getBundle(string, locale));
    }

    @Nonnull
    public static ResourceBundle getBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        return Utf8ResourceBundle._createUtf8PropertyResourceBundle(ResourceBundle.getBundle(string, locale, classLoader));
    }
}

