/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange;

import com.helger.annotation.WillClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.stream.StringInputStream;
import com.helger.base.state.ESuccess;
import com.helger.io.file.FileHelper;
import com.helger.settings.ISettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ISettingsPersistence {
    public @NonNull Charset getCharset();

    default public @NonNull ISettings readSettings(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Settings");
        return this.readSettings((InputStream)new StringInputStream(string, this.getCharset()));
    }

    default public @NonNull ISettings readSettings(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.readSettings(FileHelper.getInputStream((File)file));
    }

    default public @NonNull ISettings readSettings(@NonNull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            throw new IllegalArgumentException("Failed to open the provided input stream for the settings: " + String.valueOf(iHasInputStream));
        }
        return this.readSettings(inputStream);
    }

    public @Nullable ISettings readSettings(@WillClose @NonNull InputStream var1);

    default public @Nullable String writeSettings(@NonNull ISettings iSettings) {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        if (this.writeSettings(iSettings, (OutputStream)nonBlockingByteArrayOutputStream).isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream.getAsString(this.getCharset());
    }

    default public @NonNull ESuccess writeSettings(@NonNull ISettings iSettings, @NonNull File file) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
        if (fileOutputStream == null) {
            throw new IllegalArgumentException("Failed to open file '" + file.getAbsolutePath() + "' for writing!");
        }
        return this.writeSettings(iSettings, fileOutputStream);
    }

    public @NonNull ESuccess writeSettings(@NonNull ISettings var1, @WillClose @NonNull OutputStream var2);
}

