/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.configfile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resourceprovider.DefaultResourceProvider;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.TrimmedValueSettings;
import com.helger.settings.exchange.properties.SettingsPersistenceProperties;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ConfigFileBuilder
implements IBuilder<ConfigFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileBuilder.class);
    private ISettingsPersistence m_aSPP = new SettingsPersistenceProperties(TrimmedValueSettings::new);
    private IReadableResourceProvider m_aResProvider = new DefaultResourceProvider();
    private final ICommonsList<String> m_aPaths = new CommonsArrayList();

    @Nonnull
    public ConfigFileBuilder settingsPersistence(@Nonnull ISettingsPersistence iSettingsPersistence) {
        ValueEnforcer.notNull((Object)iSettingsPersistence, (String)"SPP");
        this.m_aSPP = iSettingsPersistence;
        return this;
    }

    @Nonnull
    public ISettingsPersistence settingsPersistence() {
        return this.m_aSPP;
    }

    @Nonnull
    public ConfigFileBuilder resourceProvider(@Nonnull IReadableResourceProvider iReadableResourceProvider) {
        ValueEnforcer.notNull((Object)iReadableResourceProvider, (String)"ResProvider");
        this.m_aResProvider = iReadableResourceProvider;
        return this;
    }

    @Nonnull
    public IReadableResourceProvider resourceProvider() {
        return this.m_aResProvider;
    }

    @Nonnull
    public ConfigFileBuilder addPathFromSystemProperty(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SystemPropertyName");
        return this.addPath(() -> SystemProperties.getPropertyValueOrNull((String)string));
    }

    @Nonnull
    public ConfigFileBuilder addPathFromEnvVar(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"EnvVarName");
        return this.addPath(() -> System.getenv().get(string));
    }

    @Nonnull
    public ConfigFileBuilder addPath(@Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(supplier, (String)"Supplier");
        return this.addPath(supplier.get());
    }

    @Nonnull
    public ConfigFileBuilder addPath(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.m_aPaths.add((Object)string);
        }
        return this;
    }

    @Nonnull
    public ConfigFileBuilder addPaths(String ... stringArray) {
        ValueEnforcer.notNullNoNullValue((Object[])stringArray, (String)"ConfigPaths");
        for (String string : stringArray) {
            this.addPath(string);
        }
        return this;
    }

    @Nonnull
    public ConfigFileBuilder addPaths(@Nonnull Iterable<String> iterable) {
        ValueEnforcer.notNullNoNullValue(iterable, (String)"ConfigPaths");
        for (String string : iterable) {
            this.addPath(string);
        }
        return this;
    }

    @Nonnull
    public ConfigFileBuilder path(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ConfigPath");
        this.m_aPaths.set((Object)string);
        return this;
    }

    @Nonnull
    public ConfigFileBuilder paths(String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"ConfigPaths");
        this.m_aPaths.setAll((Object[])stringArray);
        return this;
    }

    @Nonnull
    public ConfigFileBuilder paths(@Nonnull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"ConfigPaths");
        this.m_aPaths.setAll(iterable);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllPaths() {
        return (ICommonsList)this.m_aPaths.getClone();
    }

    @Nonnull
    @ReturnsImmutableObject
    public ICommonsIterable<String> paths() {
        return this.m_aPaths;
    }

    @Nonnull
    public ConfigFile build() {
        InputStream inputStream;
        String string;
        if (this.m_aPaths.isEmpty()) {
            throw new IllegalStateException("No config file path was provided!");
        }
        IReadableResource iReadableResource = null;
        ISettings iSettings = null;
        Iterator iterator = this.m_aPaths.iterator();
        while (iterator.hasNext() && (!this.m_aResProvider.supportsReading(string = (String)iterator.next()) || (iReadableResource = this.m_aResProvider.getReadableResource(string)) == null || (inputStream = iReadableResource.getInputStream()) == null || (iSettings = this.m_aSPP.readSettings(inputStream)) == null)) {
        }
        if (iSettings == null) {
            LOGGER.warn("Failed to resolve config file paths: " + this.m_aPaths);
        }
        return new ConfigFile(iSettings != null ? iReadableResource : null, iSettings);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SettingsPersistencyProvider", (Object)this.m_aSPP).append("ResourceProvider", (Object)this.m_aResProvider).append("Paths", this.m_aPaths).getToString();
    }
}

