/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.security.authentication.result.AuthTokenIDGenerator;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.result.IAuthToken;
import java.time.Duration;
import java.time.LocalDateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class AuthToken
implements IAuthToken {
    private final String m_sID;
    private final IAuthIdentification m_aIdentification;
    private final LocalDateTime m_aCreationDT;
    private LocalDateTime m_aLastAccessDT;
    private final int m_nExpirationSeconds;
    private boolean m_bExpired;

    public AuthToken(@NonNull IAuthIdentification iAuthIdentification, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)iAuthIdentification, (String)"Identification");
        ValueEnforcer.isGE0((int)n, (String)"ExpirationSeconds");
        this.m_sID = AuthTokenIDGenerator.generateNewTokenID();
        if (StringHelper.isEmpty((String)this.m_sID)) {
            throw new IllegalStateException("Failed to create token ID");
        }
        this.m_aIdentification = iAuthIdentification;
        this.m_aLastAccessDT = this.m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
        this.m_nExpirationSeconds = n;
        this.m_bExpired = false;
    }

    @Override
    public @NonNull String getID() {
        return this.m_sID;
    }

    @Override
    public @NonNull IAuthIdentification getIdentification() {
        return this.m_aIdentification;
    }

    @Override
    public @NonNull LocalDateTime getCreationDate() {
        return this.m_aCreationDT;
    }

    @Override
    public @NonNull LocalDateTime getLastAccessDate() {
        return this.m_aLastAccessDT;
    }

    @Override
    @Nonnegative
    public int getExpirationSeconds() {
        return this.m_nExpirationSeconds;
    }

    @Override
    public boolean isExpirationPossible() {
        return this.m_nExpirationSeconds > 0;
    }

    @Override
    public @Nullable LocalDateTime getExpirationDate() {
        return this.isExpirationPossible() ? this.m_aLastAccessDT.plusSeconds(this.m_nExpirationSeconds) : null;
    }

    @Override
    public boolean isExpired() {
        if (!this.m_bExpired && this.isExpirationPossible() && Duration.between(this.m_aLastAccessDT, PDTFactory.getCurrentLocalDateTime()).getSeconds() > (long)this.m_nExpirationSeconds) {
            this.m_bExpired = true;
        }
        return this.m_bExpired;
    }

    void setExpired() {
        this.m_bExpired = true;
    }

    void updateLastAccess() {
        this.m_aLastAccessDT = PDTFactory.getCurrentLocalDateTime();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuthToken authToken = (AuthToken)object;
        return this.m_sID.equals(authToken.m_sID) && this.m_aIdentification.equals(authToken.m_aIdentification) && this.m_aCreationDT.equals(authToken.m_aCreationDT) && this.m_aLastAccessDT.equals(authToken.m_aLastAccessDT) && this.m_bExpired == authToken.m_bExpired && this.m_nExpirationSeconds == authToken.m_nExpirationSeconds;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_aIdentification).append((Object)this.m_aCreationDT).append((Object)this.m_aLastAccessDT).append(this.m_bExpired).append(this.m_nExpirationSeconds).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("id", (Object)this.m_sID).append("identification", (Object)this.m_aIdentification).append("creationDT", (Object)this.m_aCreationDT).append("lastAccessDT", (Object)this.m_aLastAccessDT).append("expired", this.m_bExpired).append("expirationSeconds", this.m_nExpirationSeconds).getToString();
    }
}

