/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.revocation;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.MappedCache;
import com.helger.datetime.expiration.ExpiringObject;
import com.helger.security.revocation.ERevoked;
import jakarta.annotation.Nonnull;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RevocationCheckResultCache {
    public static final int DEFAULT_MAX_SIZE = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationCheckResultCache.class);
    private final MappedCache<X509Certificate, String, ExpiringObject<ERevoked>> m_aCache;
    private final Function<X509Certificate, ERevoked> m_aRevocationChecker;
    private final Duration m_aCachingDuration;

    @Nonnull
    private static String _getKey(@Nonnull X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal().getName() + "-" + x509Certificate.getIssuerX500Principal().getName() + "-" + x509Certificate.getSerialNumber().toString();
    }

    public RevocationCheckResultCache(@Nonnull Function<X509Certificate, ERevoked> function, @Nonnull Duration duration) {
        this(function, duration, 1000);
    }

    public RevocationCheckResultCache(@Nonnull Function<X509Certificate, ERevoked> function, @Nonnull Duration duration, int n) {
        ValueEnforcer.notNull((Object)duration, (String)"CachingDuration");
        ValueEnforcer.isFalse(duration::isNegative, (String)"CachingDuration must not be negative");
        this.m_aCache = new MappedCache(RevocationCheckResultCache::_getKey, x509Certificate -> {
            ERevoked eRevoked = (ERevoked)function.apply((X509Certificate)x509Certificate);
            return ExpiringObject.ofDuration((Object)eRevoked, (Duration)duration);
        }, n, "CertificateRevocationCache", false);
        this.m_aRevocationChecker = function;
        this.m_aCachingDuration = duration;
    }

    @Nonnull
    public final Function<X509Certificate, ERevoked> getRevocationChecker() {
        return this.m_aRevocationChecker;
    }

    @Nonnull
    public final Duration getCachingDuration() {
        return this.m_aCachingDuration;
    }

    public boolean isRevoked(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        ExpiringObject expiringObject = (ExpiringObject)this.m_aCache.getFromCache((Object)x509Certificate);
        if (expiringObject.isExpiredNow()) {
            LOGGER.info("The cached entry for certificate '" + RevocationCheckResultCache._getKey(x509Certificate) + "' is expired and needs to be re-fetched.");
            this.m_aCache.removeFromCache((Object)x509Certificate);
            expiringObject = (ExpiringObject)this.m_aCache.getFromCache((Object)x509Certificate);
        }
        return ((ERevoked)expiringObject.getObject()).isRevoked();
    }

    @Nonnull
    public EChange clearCache() {
        return this.m_aCache.clearCache();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Cache", this.m_aCache).append("RevocationChecker", this.m_aRevocationChecker).append("CachingDuration", (Object)this.m_aCachingDuration).getToString();
    }
}

