/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class CredentialValidationResultList
implements ICredentialValidationResult {
    private final ICommonsList<ICredentialValidationResult> m_aResults;
    private final boolean m_bFailure;

    public CredentialValidationResultList(@Nonnull @Nonempty Iterable<? extends ICredentialValidationResult> iterable) {
        ValueEnforcer.notEmpty(iterable, (String)"Results");
        this.m_aResults = new CommonsArrayList(iterable);
        this.m_bFailure = this.m_aResults.containsAny(ISuccessIndicator::isFailure);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ICredentialValidationResult> getResults() {
        return (ICommonsList)this.m_aResults.getClone();
    }

    public boolean isSuccess() {
        return !this.m_bFailure;
    }

    public boolean isFailure() {
        return this.m_bFailure;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return StringImplode.getImplodedMapped((char)'\n', this.m_aResults, iCredentialValidationResult -> iCredentialValidationResult.getDisplayText(locale));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Results", this.m_aResults).append("Failure", this.m_bFailure).getToString();
    }
}

