/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StringInputStream;
import com.helger.commons.string.StringHelper;
import com.helger.security.certificate.ECertificateCheckResult;
import com.helger.security.revocation.AbstractRevocationCheckBuilder;
import com.helger.security.revocation.RevocationCheckResultCache;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CertificateHelper {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    @Deprecated(forRemoval=true, since="11.1.1")
    public static final String BEGIN_CERTIFICATE_INVALID = "-----BEGINCERTIFICATE-----";
    @Deprecated(forRemoval=true, since="11.1.1")
    public static final String END_CERTIFICATE_INVALID = "-----ENDCERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String CRLF = "\r\n";
    public static final Charset CERT_CHARSET = StandardCharsets.ISO_8859_1;
    public static final String PRINCIPAL_TYPE_CN = "CN";
    public static final String PRINCIPAL_TYPE_O = "O";
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateHelper.class);
    private static final CertificateHelper INSTANCE = new CertificateHelper();

    private CertificateHelper() {
    }

    @Nonnull
    public static CertificateFactory getX509CertificateFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    @Deprecated(forRemoval=true, since="11.1.1")
    @Nonnull
    public static String getWithPEMHeader(@Nonnull String string) {
        return CertificateHelper.getCertificateWithPEMHeader(string);
    }

    @Nonnull
    public static String getCertificateWithPEMHeader(@Nonnull String string) {
        Object object = string;
        if (!((String)object).startsWith(BEGIN_CERTIFICATE)) {
            object = "-----BEGIN CERTIFICATE-----\n" + (String)object;
        }
        if (!((String)object).trim().endsWith(END_CERTIFICATE)) {
            object = (String)object + "\n-----END CERTIFICATE-----";
        }
        return object;
    }

    @Nullable
    public static String getWithoutPEMHeader(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = string.trim();
        string2 = StringHelper.trimStart((String)string2, (String)BEGIN_CERTIFICATE_INVALID);
        string2 = StringHelper.trimEnd((String)string2, (String)END_CERTIFICATE_INVALID);
        string2 = StringHelper.trimStart((String)string2, (String)BEGIN_CERTIFICATE);
        string2 = StringHelper.trimEnd((String)string2, (String)END_CERTIFICATE);
        return StringHelper.getWithoutAnySpaces((String)string2);
    }

    @Nullable
    public static String getRFC1421CompliantString(@Nullable String string, boolean bl) {
        return CertificateHelper.getRFC1421CompliantString(string, bl, CRLF);
    }

    @Nullable
    public static String getRFC1421CompliantString(@Nullable String string, boolean bl, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"LineSeparator");
        String string3 = CertificateHelper.getWithoutPEMHeader(string);
        if (StringHelper.hasNoText((String)string3)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(BEGIN_CERTIFICATE).append('\n');
        }
        while (string3.length() > 64) {
            stringBuilder.append(string3, 0, 64).append(string2);
            string3 = string3.substring(64);
        }
        stringBuilder.append(string3);
        if (bl) {
            stringBuilder.append('\n').append(END_CERTIFICATE);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static X509Certificate convertByteArrayToCertficate(@Nullable byte[] byArray) throws CertificateException {
        if (ArrayHelper.isEmpty((byte[])byArray)) {
            return null;
        }
        return CertificateHelper.convertStringToCertficate(new String(byArray, CERT_CHARSET), false);
    }

    @Nullable
    public static X509Certificate convertByteArrayToCertficateOrNull(@Nullable byte[] byArray) {
        try {
            return CertificateHelper.convertByteArrayToCertficate(byArray);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    @Nullable
    public static X509Certificate convertByteArrayToCertficateDirect(@Nullable byte[] byArray) throws CertificateException {
        if (ArrayHelper.isEmpty((byte[])byArray)) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)nonBlockingByteArrayInputStream);
            return x509Certificate;
        }
    }

    @Nonnull
    private static X509Certificate _str2cert(@Nonnull String string, @Nonnull CertificateFactory certificateFactory) throws CertificateException {
        String string2 = CertificateHelper.getRFC1421CompliantString(string, true);
        try (StringInputStream stringInputStream = new StringInputStream(string2, CERT_CHARSET);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)stringInputStream);
            return x509Certificate;
        }
    }

    @Nullable
    public static X509Certificate convertStringToCertficate(@Nullable String string) throws CertificateException {
        return CertificateHelper.convertStringToCertficate(string, false);
    }

    @Nullable
    public static X509Certificate convertStringToCertficate(@Nullable String string, boolean bl) throws CertificateException {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
        try {
            return CertificateHelper._str2cert(string, certificateFactory);
        }
        catch (IllegalArgumentException | CertificateException exception) {
            String string2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to decode provided X.509 certificate string: " + string);
            }
            if (!bl) {
                throw exception;
            }
            try {
                string2 = new String(StringHelper.getHexDecoded((String)string), CERT_CHARSET);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw exception;
            }
            return CertificateHelper._str2cert(string2, certificateFactory);
        }
    }

    @Nullable
    public static X509Certificate convertStringToCertficateOrNull(@Nullable String string) {
        try {
            return CertificateHelper.convertStringToCertficate(string, false);
        }
        catch (IllegalArgumentException | CertificateException exception) {
            return null;
        }
    }

    @Nullable
    public static byte[] convertCertificateStringToByteArray(@Nullable String string) {
        String string2 = CertificateHelper.getWithoutPEMHeader(string);
        if (StringHelper.hasNoText((String)string2)) {
            return null;
        }
        return Base64.safeDecode((String)string2);
    }

    @Nonnull
    @Nonempty
    public static byte[] getEncodedCertificate(@Nonnull Certificate certificate) {
        ValueEnforcer.notNull((Object)certificate, (String)"Cert");
        try {
            return certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Failed to encode certificate " + String.valueOf(certificate), certificateEncodingException);
        }
    }

    @Nonnull
    @Nonempty
    public static String getPEMEncodedCertificate(@Nonnull Certificate certificate) {
        ValueEnforcer.notNull((Object)certificate, (String)"Cert");
        try {
            String string = Base64.encodeBytes((byte[])certificate.getEncoded());
            return "-----BEGIN CERTIFICATE-----\n" + string + "\n-----END CERTIFICATE-----";
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Failed to encode certificate " + String.valueOf(certificate), certificateEncodingException);
        }
    }

    public static boolean isCertificateValidPerNow(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        try {
            x509Certificate.checkValidity();
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
            return false;
        }
    }

    @Nullable
    public static PrivateKey convertStringToPrivateKey(@Nullable String string) throws GeneralSecurityException {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = StringHelper.trimStart((String)string, (String)BEGIN_PRIVATE_KEY);
        string2 = StringHelper.trimEnd((String)string2, (String)END_PRIVATE_KEY);
        byte[] byArray = Base64.safeDecode((String)(string2 = StringHelper.getWithoutAnySpaces((String)string2)));
        if (byArray == null) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public static boolean isCA(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        byte[] byArray = x509Certificate.getExtensionValue(Extension.basicConstraints.getId());
        if (byArray != null) {
            try {
                ASN1Sequence aSN1Sequence;
                BasicConstraints basicConstraints;
                ASN1Primitive aSN1Primitive = JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray);
                if (aSN1Primitive instanceof ASN1Sequence && (basicConstraints = BasicConstraints.getInstance((Object)(aSN1Sequence = (ASN1Sequence)aSN1Primitive))) != null) {
                    return basicConstraints.isCA();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nonnull
    public static ECertificateCheckResult checkCertificate(@Nullable ICommonsSet<X500Principal> iCommonsSet, @Nullable RevocationCheckResultCache revocationCheckResultCache, @Nonnull AbstractRevocationCheckBuilder<?> abstractRevocationCheckBuilder) {
        X509Certificate x509Certificate;
        ValueEnforcer.notNull(abstractRevocationCheckBuilder, (String)"RevocationChecker");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Running Certificate Check" + (String)(iCommonsSet != null ? " against a list of " + iCommonsSet.size() + " certificate issuers" : "") + (revocationCheckResultCache != null ? "; a cache is provided" : "; not using a cache"));
        }
        if ((x509Certificate = abstractRevocationCheckBuilder.certificate()) == null) {
            LOGGER.warn("No Certificate was provided to the certificate check");
            return ECertificateCheckResult.NO_CERTIFICATE_PROVIDED;
        }
        Date date = abstractRevocationCheckBuilder.checkDate();
        try {
            if (date == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking the Certificate validity against the current date time");
                }
                x509Certificate.checkValidity();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking the Certificate validity against the provided date time " + String.valueOf(date));
                }
                x509Certificate.checkValidity(date);
            }
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            LOGGER.warn("The provided Certificate is not yet valid per " + (date == null ? "now" : date.toString()));
            return ECertificateCheckResult.NOT_YET_VALID;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            LOGGER.warn("The provided Certificate is expired per " + (date == null ? "now" : date.toString()));
            return ECertificateCheckResult.EXPIRED;
        }
        if (iCommonsSet != null) {
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            if (!iCommonsSet.contains((Object)x500Principal)) {
                LOGGER.warn("The provided Certificate issuer '" + String.valueOf(x500Principal) + "' is not in the list of trusted issuers " + String.valueOf(iCommonsSet));
                return ECertificateCheckResult.UNSUPPORTED_ISSUER;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Not testing against known Certificate issuers");
        }
        if (revocationCheckResultCache != null) {
            boolean bl;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing if the Certificate is revoked, using a cache");
            }
            if (bl = revocationCheckResultCache.isRevoked(x509Certificate)) {
                LOGGER.warn("The Certificate is revoked [caching used]");
                return ECertificateCheckResult.REVOKED;
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing if the Certificate is revoked, without a cache");
            }
            if (abstractRevocationCheckBuilder.build().isRevoked()) {
                LOGGER.warn("The Certificate is revoked [no caching]");
                return ECertificateCheckResult.REVOKED;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The Certificate seems to be valid");
        }
        return ECertificateCheckResult.VALID;
    }

    @Nullable
    public static String getPrincipalTypeValue(@Nullable String string, @Nonnull String string2) throws InvalidNameException {
        ValueEnforcer.notNull((Object)string2, (String)"Type");
        if (string != null) {
            for (Rdn rdn : new LdapName(string).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase(string2)) continue;
                return (String)rdn.getValue();
            }
        }
        return null;
    }

    @Nullable
    public static String getCN(@Nullable String string) throws InvalidNameException {
        return CertificateHelper.getPrincipalTypeValue(string, PRINCIPAL_TYPE_CN);
    }

    @Nullable
    public static String getSubjectCN(@Nullable X509Certificate x509Certificate) {
        return x509Certificate != null ? CertificateHelper.getCNOrNull(x509Certificate.getSubjectX500Principal()) : null;
    }

    @Nullable
    public static String getCNOrNull(@Nullable X500Principal x500Principal) {
        return x500Principal != null ? CertificateHelper.getCNOrNull(x500Principal.getName()) : null;
    }

    @Nullable
    public static String getCNOrNull(@Nullable String string) {
        try {
            return CertificateHelper.getCN(string);
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    @Nullable
    public static String getO(@Nullable String string) throws InvalidNameException {
        return CertificateHelper.getPrincipalTypeValue(string, PRINCIPAL_TYPE_O);
    }

    @Nullable
    public static String getSubjectO(@Nullable X509Certificate x509Certificate) {
        return x509Certificate != null ? CertificateHelper.getOOrNull(x509Certificate.getSubjectX500Principal()) : null;
    }

    @Nullable
    public static String getOOrNull(@Nullable X500Principal x500Principal) {
        return x500Principal != null ? CertificateHelper.getOOrNull(x500Principal.getName()) : null;
    }

    @Nullable
    public static String getOOrNull(@Nullable String string) {
        try {
            return CertificateHelper.getO(string);
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }
}

