/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.subject.IAuthSubject;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AuthIdentification
implements IAuthIdentification {
    private final IAuthSubject m_aAuthSubject;
    private final LocalDateTime m_aIdentificationDT;

    public AuthIdentification(@Nullable IAuthSubject iAuthSubject) {
        this.m_aAuthSubject = iAuthSubject;
        this.m_aIdentificationDT = PDTFactory.getCurrentLocalDateTime();
    }

    @Override
    @Nullable
    public IAuthSubject getAuthSubject() {
        return this.m_aAuthSubject;
    }

    @Override
    @Nonnull
    public LocalDateTime getIdentificationDateTime() {
        return this.m_aIdentificationDT;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuthIdentification authIdentification = (AuthIdentification)object;
        return EqualsHelper.equals((Object)this.m_aAuthSubject, (Object)authIdentification.m_aAuthSubject) && this.m_aIdentificationDT.equals(authIdentification.m_aIdentificationDT);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aAuthSubject).append((Object)this.m_aIdentificationDT).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("AuthSubject", (Object)this.m_aAuthSubject).append("IdentificationDT", (Object)this.m_aIdentificationDT).getToString();
    }
}

