/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.salt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.bcrypt.BCrypt;
import com.helger.security.password.salt.IPasswordSalt;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Nonnegative
@Immutable
public final class PasswordSaltBCrypt
implements IPasswordSalt {
    private final byte[] m_aBytes;
    private final String m_sSalt;

    public PasswordSaltBCrypt() {
        this(10);
    }

    public PasswordSaltBCrypt(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"Rounds");
        this.m_sSalt = BCrypt.gensalt(n);
        this.m_aBytes = this.m_sSalt.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    @Nonnegative
    public int getSaltByteCount() {
        return this.m_aBytes.length;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getSaltBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aBytes);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSaltString() {
        return this.m_sSalt;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordSaltBCrypt passwordSaltBCrypt = (PasswordSaltBCrypt)object;
        return Arrays.equals(this.m_aBytes, passwordSaltBCrypt.m_aBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Salt", (Object)this.m_sSalt).getToString();
    }
}

