/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.scope.AbstractScope;
import com.helger.scope.IRequestScope;
import com.helger.scope.ScopeHelper;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScope
extends AbstractScope
implements IRequestScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestScope.class);
    private final String m_sSessionID;

    public RequestScope(@Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        super(string);
        this.m_sSessionID = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"SessionID");
        if (ScopeHelper.isDebugRequestScopeLifeCycle()) {
            LOGGER.info("Created request scope '" + string + "'", (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    @Nonempty
    public final @NonNull String getSessionID(boolean bl) {
        return this.m_sSessionID;
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.isDebugRequestScopeLifeCycle()) {
            LOGGER.info("Destroying request scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.isDebugRequestScopeLifeCycle()) {
            LOGGER.info("Destroyed request scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("sessionID", (Object)this.m_sSessionID).getToString();
    }
}

