/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.scope.GlobalScope;
import com.helger.scope.IGlobalScope;
import com.helger.scope.IRequestScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.RequestScope;
import com.helger.scope.ScopeHelper;
import com.helger.scope.SessionScope;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.scope.spi.ScopeSPIManager;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ScopeManager {
    public static final String SCOPE_ATTRIBUTE_PREFIX_INTERNAL = "$ph-";
    public static final boolean DEFAULT_CREATE_SCOPE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeManager.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IGlobalScope s_aGlobalScope;
    private static final ThreadLocal<IRequestScope> REQUEST_SCOPE_THREAD_LOCAL;
    private static final ScopeManager INSTANCE;

    private ScopeManager() {
    }

    public static void setGlobalScope(@Nonnull IGlobalScope iGlobalScope) {
        ValueEnforcer.notNull((Object)iGlobalScope, (String)"GlobalScope");
        RW_LOCK.writeLocked(() -> {
            if (s_aGlobalScope != null) {
                throw new IllegalStateException("Another global scope with ID '" + s_aGlobalScope.getID() + "' is already present. New global scope with ID '" + iGlobalScope.getID() + "' is not set!");
            }
            s_aGlobalScope = iGlobalScope;
        });
        iGlobalScope.initScope();
        if (ScopeHelper.isDebugGlobalScopeLifeCycle()) {
            LOGGER.info("Global scope '" + iGlobalScope.getID() + "' initialized!", (Throwable)ScopeHelper.getDebugException());
        }
        ScopeSPIManager.getInstance().onGlobalScopeBegin(iGlobalScope);
    }

    @Nonnull
    public static IGlobalScope onGlobalBegin(@Nonnull @Nonempty String string) {
        return ScopeManager.onGlobalBegin(string, GlobalScope::new);
    }

    @Nonnull
    public static <T extends IGlobalScope> T onGlobalBegin(@Nonnull @Nonempty String string, @Nonnull Function<? super String, T> function) {
        IGlobalScope iGlobalScope = (IGlobalScope)function.apply(string);
        ScopeManager.setGlobalScope(iGlobalScope);
        return (T)iGlobalScope;
    }

    @Nullable
    public static IGlobalScope getGlobalScopeOrNull() {
        IGlobalScope iGlobalScope = (IGlobalScope)RW_LOCK.readLockedGet(() -> s_aGlobalScope);
        if (iGlobalScope != null && iGlobalScope.isValid()) {
            return iGlobalScope;
        }
        return null;
    }

    public static boolean isGlobalScopePresent() {
        return ScopeManager.getGlobalScopeOrNull() != null;
    }

    @Nonnull
    public static IGlobalScope getGlobalScope() {
        IGlobalScope iGlobalScope = ScopeManager.getGlobalScopeOrNull();
        if (iGlobalScope == null) {
            throw new IllegalStateException("No global scope object has been set!");
        }
        return iGlobalScope;
    }

    public static void onGlobalEnd() {
        IGlobalScope iGlobalScope = (IGlobalScope)RW_LOCK.writeLockedGet(() -> {
            IGlobalScope iGlobalScope = s_aGlobalScope;
            s_aGlobalScope = null;
            return iGlobalScope;
        });
        if (iGlobalScope != null) {
            ScopeSPIManager.getInstance().onGlobalScopeEnd(iGlobalScope);
            String string = iGlobalScope.getID();
            iGlobalScope.destroyScope();
            if (ScopeHelper.isDebugGlobalScopeLifeCycle()) {
                LOGGER.info("Global scope '" + string + "' shut down!", (Throwable)ScopeHelper.getDebugException());
            }
        } else {
            LOGGER.warn("No global scope present that could be shut down!");
        }
    }

    @Nonnull
    public static ISessionScope getSessionScope() {
        return ScopeManager.getSessionScope(true);
    }

    @Nullable
    public static ISessionScope getSessionScope(boolean bl) {
        return ScopeManager.getSessionScope(bl, SessionScope::new);
    }

    @Nullable
    public static ISessionScope getSessionScope(boolean bl, @Nonnull Function<? super String, ? extends ISessionScope> function) {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        if (iRequestScope != null) {
            String string;
            ScopeSessionManager scopeSessionManager = ScopeSessionManager.getInstance();
            ISessionScope iSessionScope = scopeSessionManager.getSessionScopeOfID(string = iRequestScope.getSessionID(bl));
            if (iSessionScope == null && bl) {
                if (string == null) {
                    throw new IllegalStateException("Cannot create a SessionScope without a known session ID!");
                }
                iSessionScope = function.apply(string);
                scopeSessionManager.onScopeBegin(iSessionScope);
            }
            return iSessionScope;
        }
        if (bl) {
            throw new IllegalStateException("No request scope is present, so no session scope can be created!");
        }
        return null;
    }

    public static void destroySessionScope(@Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull((Object)iSessionScope, (String)"SessionScope");
        ScopeSessionManager.getInstance().onScopeEnd(iSessionScope);
    }

    public static void internalSetAndInitRequestScope(@Nonnull IRequestScope iRequestScope) {
        ValueEnforcer.notNull((Object)iRequestScope, (String)"RequestScope");
        ValueEnforcer.isTrue(ScopeManager::isGlobalScopePresent, (String)"No global context present! May be the global context listener is not installed?");
        IRequestScope iRequestScope2 = REQUEST_SCOPE_THREAD_LOCAL.get();
        if (iRequestScope2 != null) {
            LOGGER.warn("A request scope is already present - will overwrite it: " + iRequestScope2.toString());
            if (iRequestScope2.isValid()) {
                LOGGER.warn("Destroying the old request scope before the new one gets initialized!");
                ScopeManager._destroyRequestScope(iRequestScope2);
            }
        }
        REQUEST_SCOPE_THREAD_LOCAL.set(iRequestScope);
        iRequestScope.initScope();
        ScopeSPIManager.getInstance().onRequestScopeBegin(iRequestScope);
    }

    @Nonnull
    public static IRequestScope onRequestBegin(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return ScopeManager.onRequestBegin(string, string2, RequestScope::new);
    }

    @Nonnull
    public static <T extends IRequestScope> T onRequestBegin(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull BiFunction<? super String, ? super String, T> biFunction) {
        IRequestScope iRequestScope = (IRequestScope)biFunction.apply(string, string2);
        ScopeManager.internalSetAndInitRequestScope(iRequestScope);
        return (T)iRequestScope;
    }

    @Nullable
    public static IRequestScope getRequestScopeOrNull() {
        return REQUEST_SCOPE_THREAD_LOCAL.get();
    }

    public static boolean isRequestScopePresent() {
        return ScopeManager.getRequestScopeOrNull() != null;
    }

    @Nonnull
    public static IRequestScope getRequestScope() {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        if (iRequestScope == null) {
            throw new IllegalStateException("No request scope is available.");
        }
        return iRequestScope;
    }

    private static void _destroyRequestScope(@Nonnull IRequestScope iRequestScope) {
        ScopeSPIManager.getInstance().onRequestScopeEnd(iRequestScope);
        iRequestScope.destroyScope();
    }

    public static void internalClearRequestScope() {
        REQUEST_SCOPE_THREAD_LOCAL.remove();
    }

    public static void onRequestEnd() {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        try {
            if (iRequestScope != null) {
                ScopeManager._destroyRequestScope(iRequestScope);
            } else {
                LOGGER.warn("No request scope present that could be ended!");
            }
        }
        finally {
            ScopeManager.internalClearRequestScope();
        }
    }

    public static boolean isInternalAttribute(@Nullable String string) {
        return StringHelper.startsWith((String)string, (String)SCOPE_ATTRIBUTE_PREFIX_INTERNAL);
    }

    static {
        REQUEST_SCOPE_THREAD_LOCAL = new ThreadLocal();
        INSTANCE = new ScopeManager();
    }
}

