/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.numeric.MathHelper;
import com.helger.matrix.Matrix;
import org.jspecify.annotations.NonNull;

public class QRDecomposition {
    private final double[][] m_aQR;
    private final int m_nRows;
    private final int m_nCols;
    private final double[] m_aRdiag;

    public QRDecomposition(@NonNull Matrix matrix) {
        this.m_aQR = matrix.getArrayCopy();
        this.m_nRows = matrix.getRowDimension();
        this.m_nCols = matrix.getColumnDimension();
        this.m_aRdiag = new double[this.m_nCols];
        for (int i = 0; i < this.m_nCols; ++i) {
            int n;
            double d = 0.0;
            for (n = i; n < this.m_nRows; ++n) {
                d = MathHelper.hypot((double)d, (double)this.m_aQR[n][i]);
            }
            if (d != 0.0) {
                if (this.m_aQR[i][i] < 0.0) {
                    d = -d;
                }
                for (n = i; n < this.m_nRows; ++n) {
                    double[] dArray = this.m_aQR[n];
                    int n2 = i;
                    dArray[n2] = dArray[n2] / d;
                }
                double[] dArray = this.m_aQR[i];
                int n3 = i;
                dArray[n3] = dArray[n3] + 1.0;
                for (n = i + 1; n < this.m_nCols; ++n) {
                    int n4;
                    double d2 = 0.0;
                    for (n4 = i; n4 < this.m_nRows; ++n4) {
                        d2 += this.m_aQR[n4][i] * this.m_aQR[n4][n];
                    }
                    d2 = -d2 / this.m_aQR[i][i];
                    for (n4 = i; n4 < this.m_nRows; ++n4) {
                        double[] dArray2 = this.m_aQR[n4];
                        int n5 = n;
                        dArray2[n5] = dArray2[n5] + d2 * this.m_aQR[n4][i];
                    }
                }
            }
            this.m_aRdiag[i] = -d;
        }
    }

    public boolean isFullRank() {
        for (int i = 0; i < this.m_nCols; ++i) {
            if (this.m_aRdiag[i] != 0.0) continue;
            return false;
        }
        return true;
    }

    @ReturnsMutableCopy
    public @NonNull Matrix getH() {
        Matrix matrix = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aQR[i];
            double[] dArray3 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray3[j] = i >= j ? dArray2[j] : 0.0;
            }
        }
        return matrix;
    }

    @ReturnsMutableCopy
    public @NonNull Matrix getR() {
        Matrix matrix = new Matrix(this.m_nCols, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nCols; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray2[j] = i < j ? this.m_aQR[i][j] : (i == j ? this.m_aRdiag[i] : 0.0);
            }
        }
        return matrix;
    }

    @ReturnsMutableCopy
    public @NonNull Matrix getQ() {
        Matrix matrix = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = this.m_nCols - 1; i >= 0; --i) {
            int n;
            double[] dArray2 = this.m_aQR[i];
            for (n = 0; n < this.m_nRows; ++n) {
                dArray[n][i] = 0.0;
            }
            dArray[i][i] = 1.0;
            for (n = i; n < this.m_nCols; ++n) {
                int n2;
                if (dArray2[i] == 0.0) continue;
                double d = 0.0;
                for (n2 = i; n2 < this.m_nRows; ++n2) {
                    d += this.m_aQR[n2][i] * dArray[n2][n];
                }
                d = -d / dArray2[i];
                for (n2 = i; n2 < this.m_nRows; ++n2) {
                    double[] dArray3 = dArray[n2];
                    int n3 = n;
                    dArray3[n3] = dArray3[n3] + d * this.m_aQR[n2][i];
                }
            }
        }
        return matrix;
    }

    @ReturnsMutableCopy
    public @NonNull Matrix solve(@NonNull Matrix matrix) {
        int n;
        int n2;
        double[] dArray;
        int n3;
        if (matrix.getRowDimension() != this.m_nRows) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new IllegalStateException("Matrix is rank deficient.");
        }
        int n4 = matrix.getColumnDimension();
        double[][] dArray2 = matrix.getArrayCopy();
        for (n3 = 0; n3 < this.m_nCols; ++n3) {
            dArray = this.m_aQR[n3];
            for (n2 = 0; n2 < n4; ++n2) {
                double d = 0.0;
                for (n = n3; n < this.m_nRows; ++n) {
                    d += this.m_aQR[n][n3] * dArray2[n][n2];
                }
                d = -d / dArray[n3];
                for (n = n3; n < this.m_nRows; ++n) {
                    double[] dArray3 = dArray2[n];
                    int n5 = n2;
                    dArray3[n5] = dArray3[n5] + d * this.m_aQR[n][n3];
                }
            }
        }
        for (n3 = this.m_nCols - 1; n3 >= 0; --n3) {
            dArray = dArray2[n3];
            n2 = 0;
            while (n2 < n4) {
                int n6 = n2++;
                dArray[n6] = dArray[n6] / this.m_aRdiag[n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                double[] dArray4 = this.m_aQR[n2];
                double[] dArray5 = dArray2[n2];
                for (n = 0; n < n4; ++n) {
                    int n7 = n;
                    dArray5[n7] = dArray5[n7] - dArray[n] * dArray4[n3];
                }
            }
        }
        return new Matrix(dArray2, this.m_nCols, n4).getMatrix(0, this.m_nCols - 1, 0, n4 - 1);
    }
}

