/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class MatrixInt
implements ICloneable<MatrixInt>,
Serializable {
    private final int[][] m_aData;
    private final int m_nRows;
    private final int m_nCols;

    public MatrixInt(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGT0((int)n, (String)"Rows");
        ValueEnforcer.isGT0((int)n2, (String)"Cols");
        this.m_nRows = n;
        this.m_nCols = n2;
        this.m_aData = new int[n][n2];
    }

    public MatrixInt(@Nonnegative int n, @Nonnegative int n2, int n3) {
        this(n, n2);
        for (int i = 0; i < n; ++i) {
            Arrays.fill(this.m_aData[i], n3);
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    MatrixInt(@Nonnull int[][] nArray) {
        ValueEnforcer.notNull((Object)nArray, (String)"Other");
        ValueEnforcer.isGT0((int)nArray.length, (String)"rows");
        ValueEnforcer.isGT0((int)nArray[0].length, (String)"cols");
        this.m_nRows = nArray.length;
        this.m_nCols = nArray[0].length;
        for (int i = 0; i < this.m_nRows; ++i) {
            if (nArray[i].length == this.m_nCols) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.m_aData = nArray;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    MatrixInt(@Nonnull int[][] nArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull((Object)nArray, (String)"Other");
        ValueEnforcer.isGT0((int)n, (String)"rows");
        ValueEnforcer.isGT0((int)n2, (String)"cols");
        ValueEnforcer.isTrue((nArray.length >= n ? 1 : 0) != 0, (String)"array is too short");
        for (int i = 0; i < n; ++i) {
            ValueEnforcer.isTrue((nArray[i].length >= n2 ? 1 : 0) != 0, (String)"All rows must have the same length.");
        }
        this.m_aData = nArray;
        this.m_nRows = n;
        this.m_nCols = n2;
    }

    public MatrixInt(@Nonnull int[] nArray, @Nonnegative int n) {
        this.m_nRows = n;
        int n2 = this.m_nCols = n != 0 ? nArray.length / n : 0;
        if (n * this.m_nCols != nArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of nRows.");
        }
        this.m_aData = new int[n][this.m_nCols];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray2[j] = nArray[i + j * n];
            }
        }
    }

    @Nonnull
    public static MatrixInt constructWithCopy(@Nonnull int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        MatrixInt matrixInt = new MatrixInt(n, n2);
        int[][] nArray2 = matrixInt.internalGetArray();
        for (int i = 0; i < n; ++i) {
            int[] nArray3 = nArray[i];
            int[] nArray4 = nArray2[i];
            if (nArray3.length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
        }
        return matrixInt;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt getClone() {
        MatrixInt matrixInt = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt.m_aData;
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = nArray[i];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
        }
        return matrixInt;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public int[][] internalGetArray() {
        return this.m_aData;
    }

    @Nonnull
    @ReturnsMutableCopy
    public int[][] getArrayCopy() {
        int[][] nArray = new int[this.m_nRows][this.m_nCols];
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = nArray[i];
            System.arraycopy(nArray2, 0, nArray3, 0, this.m_nCols);
        }
        return nArray;
    }

    @Nonnull
    public int[] getColumnPackedCopy() {
        int[] nArray = new int[this.m_nRows * this.m_nCols];
        for (int i = 0; i < this.m_nCols; ++i) {
            int n = i * this.m_nRows;
            for (int j = 0; j < this.m_nRows; ++j) {
                nArray[j + n] = this.m_aData[j][i];
            }
        }
        return nArray;
    }

    @Nonnull
    public int[] getRowPackedCopy() {
        int[] nArray = new int[this.m_nRows * this.m_nCols];
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray[i * this.m_nCols + j] = nArray2[j];
            }
        }
        return nArray;
    }

    @Nonnegative
    public int getRowDimension() {
        return this.m_nRows;
    }

    @Nonnegative
    public int getColumnDimension() {
        return this.m_nCols;
    }

    public boolean isSymmetrical() {
        return this.m_nRows == this.m_nCols;
    }

    public int get(@Nonnegative int n, @Nonnegative int n2) {
        return this.m_aData[n][n2];
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt getMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        MatrixInt matrixInt = new MatrixInt(n2 - n + 1, n4 - n3 + 1);
        int[][] nArray = matrixInt.internalGetArray();
        for (int i = n; i <= n2; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = nArray[i - n];
            for (int j = n3; j <= n4; ++j) {
                nArray3[j - n3] = nArray2[j];
            }
        }
        return matrixInt;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt getMatrix(@Nonnull int[] nArray, @Nonnull int[] nArray2) {
        MatrixInt matrixInt = new MatrixInt(nArray.length, nArray2.length);
        int[][] nArray3 = matrixInt.internalGetArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int[] nArray4 = this.m_aData[n];
            int[] nArray5 = nArray3[i];
            for (int j = 0; j < nArray2.length; ++j) {
                nArray5[j] = nArray4[nArray2[j]];
            }
        }
        return matrixInt;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt getMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnull int[] nArray) {
        MatrixInt matrixInt = new MatrixInt(n2 - n + 1, nArray.length);
        int[][] nArray2 = matrixInt.internalGetArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            for (int j = n; j <= n2; ++j) {
                nArray2[j - n][i] = this.m_aData[j][n3];
            }
        }
        return matrixInt;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt getMatrix(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        MatrixInt matrixInt = new MatrixInt(nArray.length, n2 - n + 1);
        int[][] nArray2 = matrixInt.internalGetArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int[] nArray3 = this.m_aData[n3];
            int[] nArray4 = nArray2[i];
            for (int j = n; j <= n2; ++j) {
                nArray4[j - n] = nArray3[j];
            }
        }
        return matrixInt;
    }

    public void set(@Nonnegative int n, @Nonnegative int n2, int n3) {
        this.m_aData[n][n2] = n3;
    }

    public void setMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull MatrixInt matrixInt) {
        for (int i = n; i <= n2; ++i) {
            int[] nArray = this.m_aData[i];
            for (int j = n3; j <= n4; ++j) {
                nArray[j] = matrixInt.get(i - n, j - n3);
            }
        }
    }

    public void setMatrix(@Nonnull int[] nArray, @Nonnull int[] nArray2, @Nonnull MatrixInt matrixInt) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int[] nArray3 = this.m_aData[n];
            for (int j = 0; j < nArray2.length; ++j) {
                nArray3[nArray2[j]] = matrixInt.get(i, j);
            }
        }
    }

    public void setMatrix(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull MatrixInt matrixInt) {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int[] nArray2 = this.m_aData[n3];
            for (int j = n; j <= n2; ++j) {
                nArray2[j] = matrixInt.get(i, j - n);
            }
        }
    }

    public void setMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnull int[] nArray, @Nonnull MatrixInt matrixInt) {
        for (int i = n; i <= n2; ++i) {
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < nArray.length; ++j) {
                int n3 = nArray[j];
                nArray2[n3] = matrixInt.get(i - n, j);
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    @ReturnsMutableCopy
    public MatrixInt transpose() {
        MatrixInt matrixInt = new MatrixInt(this.m_nCols, this.m_nRows);
        int[][] nArray = matrixInt.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray[j][i] = nArray2[j];
            }
        }
        return matrixInt;
    }

    public int norm1() {
        int n = 0;
        for (int i = 0; i < this.m_nCols; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.m_nRows; ++j) {
                n2 += MathHelper.abs((int)this.m_aData[j][i]);
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    public int normInf() {
        int n = 0;
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = this.m_aData[i];
            int n2 = 0;
            for (int j = 0; j < this.m_nCols; ++j) {
                n2 += MathHelper.abs((int)nArray[j]);
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    public double normF() {
        double d = 0.0;
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                d = MathHelper.hypot((double)d, (double)nArray[j]);
            }
        }
        return d;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt uminus() {
        MatrixInt matrixInt = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray3[j] = -nArray2[j];
            }
        }
        return matrixInt;
    }

    private void _checkMatrixDimensions(@Nonnull MatrixInt matrixInt) {
        if (matrixInt.m_nRows != this.m_nRows) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (matrixInt.m_nCols != this.m_nCols) {
            throw new IllegalArgumentException("Matrix column dimensions must agree.");
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt plus(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        MatrixInt matrixInt2 = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = matrixInt.m_aData[i];
            int[] nArray4 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray4[j] = nArray2[j] + nArray3[j];
            }
        }
        return matrixInt2;
    }

    @Nonnull
    public MatrixInt plusEquals(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = matrixInt.m_aData[i];
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                nArray2[n] = nArray2[n] + nArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt minus(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        MatrixInt matrixInt2 = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = matrixInt.m_aData[i];
            int[] nArray4 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray4[j] = nArray2[j] - nArray3[j];
            }
        }
        return matrixInt2;
    }

    @Nonnull
    public MatrixInt minusEquals(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = matrixInt.m_aData[i];
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                nArray2[n] = nArray2[n] - nArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt arrayTimes(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        MatrixInt matrixInt2 = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = matrixInt.m_aData[i];
            int[] nArray4 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray4[j] = nArray2[j] * nArray3[j];
            }
        }
        return matrixInt2;
    }

    @Nonnull
    public MatrixInt arrayTimesEquals(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = matrixInt.m_aData[i];
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                nArray2[n] = nArray2[n] * nArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt arrayRightDivide(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        MatrixInt matrixInt2 = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = matrixInt.m_aData[i];
            int[] nArray4 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray4[j] = nArray2[j] / nArray3[j];
            }
        }
        return matrixInt2;
    }

    @Nonnull
    public MatrixInt arrayRightDivideEquals(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = matrixInt.m_aData[i];
            int[] nArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                nArray2[n] = nArray2[n] / nArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt arrayLeftDivide(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        MatrixInt matrixInt2 = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = matrixInt.m_aData[i];
            int[] nArray3 = this.m_aData[i];
            int[] nArray4 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray4[j] = nArray2[j] / nArray3[j];
            }
        }
        return matrixInt2;
    }

    @Nonnull
    public MatrixInt arrayLeftDivideEquals(@Nonnull MatrixInt matrixInt) {
        this._checkMatrixDimensions(matrixInt);
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray;
            int[] nArray2 = matrixInt.m_aData[i];
            int[] nArray3 = nArray = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray3[j] = nArray2[j] / nArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt times(int n) {
        MatrixInt matrixInt = new MatrixInt(this.m_nRows, this.m_nCols);
        int[][] nArray = matrixInt.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray2 = this.m_aData[i];
            int[] nArray3 = nArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray3[j] = n * nArray2[j];
            }
        }
        return matrixInt;
    }

    @Nonnull
    public MatrixInt timesEquals(double d) {
        for (int i = 0; i < this.m_nRows; ++i) {
            int[] nArray = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                nArray[j] = (int)((double)nArray[j] * d);
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MatrixInt times(@Nonnull MatrixInt matrixInt) {
        if (matrixInt.m_nRows != this.m_nCols) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        MatrixInt matrixInt2 = new MatrixInt(this.m_nRows, matrixInt.m_nCols);
        int[][] nArray = matrixInt2.internalGetArray();
        int[] nArray2 = new int[this.m_nCols];
        for (int i = 0; i < matrixInt.m_nCols; ++i) {
            int n;
            for (n = 0; n < this.m_nCols; ++n) {
                nArray2[n] = matrixInt.m_aData[n][i];
            }
            for (n = 0; n < this.m_nRows; ++n) {
                int[] nArray3 = this.m_aData[n];
                int n2 = 0;
                for (int j = 0; j < this.m_nCols; ++j) {
                    n2 += nArray3[j] * nArray2[j];
                }
                nArray[n][i] = n2;
            }
        }
        return matrixInt2;
    }

    public int trace() {
        int n = 0;
        int n2 = Math.min(this.m_nRows, this.m_nCols);
        for (int i = 0; i < n2; ++i) {
            n += this.m_aData[i][i];
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MatrixInt random(@Nonnegative int n, @Nonnegative int n2) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        MatrixInt matrixInt = new MatrixInt(n, n2);
        int[][] nArray = matrixInt.internalGetArray();
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = 1 + ((Random)threadLocalRandom).nextInt(100);
            }
        }
        return matrixInt;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MatrixInt identity(@Nonnegative int n, @Nonnegative int n2) {
        MatrixInt matrixInt = new MatrixInt(n, n2);
        int[][] nArray = matrixInt.internalGetArray();
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = i == j ? 1 : 0;
            }
        }
        return matrixInt;
    }

    public void print(@Nonnull PrintWriter printWriter, @Nonnegative int n, @Nonnegative int n2) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setGroupingUsed(false);
        this.print(printWriter, numberFormat, n + 2);
    }

    public void print(@Nonnull PrintWriter printWriter, @Nonnull NumberFormat numberFormat, @Nonnegative int n) {
        printWriter.println();
        for (int i = 0; i < this.m_nRows; ++i) {
            for (int j = 0; j < this.m_nCols; ++j) {
                String string = numberFormat.format(this.m_aData[i][j]);
                int n2 = Math.max(1, n - string.length());
                printWriter.print(StringHelper.getRepeated((char)' ', (int)n2));
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MatrixInt matrixInt = (MatrixInt)object;
        if (this.m_nRows != matrixInt.m_nRows || this.m_nCols != matrixInt.m_nCols) {
            return false;
        }
        for (int i = 0; i < this.m_nRows; ++i) {
            if (Arrays.equals(this.m_aData[i], matrixInt.m_aData[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator((Object)this).append(this.m_nRows).append(this.m_nCols);
        for (int i = 0; i < this.m_nRows; ++i) {
            hashCodeGenerator.append(this.m_aData[i]);
        }
        return hashCodeGenerator.getHashCode();
    }

    @Nonnull
    public static MatrixInt read(@Nonnull @WillNotClose Reader reader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(StreamHelper.getBuffered((Reader)reader));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        do {
            commonsArrayList.add((Object)Integer.parseInt(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = commonsArrayList.size();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (Integer)commonsArrayList.get(i);
        }
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        commonsArrayList2.add((Object)nArray);
        while (streamTokenizer.nextToken() == -3) {
            nArray = new int[n2];
            commonsArrayList2.add((Object)nArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + commonsArrayList2.size() + " is too long.");
                }
                nArray[n++] = Integer.parseInt(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + commonsArrayList2.size() + " is too short.");
        }
        n = commonsArrayList2.size();
        return new MatrixInt((int[][])commonsArrayList2.toArray((Object[])new int[n][]));
    }
}

