/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.math.MathHelper;
import com.helger.matrix.Matrix;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class LUDecomposition {
    private final double[][] m_aLU;
    private final int m_nRows;
    private final int m_nCols;
    private final int m_nPivSign;
    private final int[] m_aPivot;

    public LUDecomposition(@Nonnull Matrix matrix) {
        int n;
        this.m_aLU = matrix.getArrayCopy();
        this.m_nRows = matrix.getRowDimension();
        this.m_nCols = matrix.getColumnDimension();
        this.m_aPivot = new int[this.m_nRows];
        for (n = 0; n < this.m_nRows; ++n) {
            this.m_aPivot[n] = n;
        }
        n = 1;
        double[] dArray = new double[this.m_nRows];
        for (int i = 0; i < this.m_nCols; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.m_nRows; ++n3) {
                dArray[n3] = this.m_aLU[n3][i];
            }
            n3 = 0;
            while (n3 < this.m_nRows) {
                double[] dArray2 = this.m_aLU[n3];
                n2 = Math.min(n3, i);
                double d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += dArray2[j] * dArray[j];
                }
                int n4 = n3++;
                double d2 = dArray[n4] - d;
                dArray[n4] = d2;
                dArray2[i] = d2;
            }
            n3 = i;
            for (n2 = i + 1; n2 < this.m_nRows; ++n2) {
                if (!(MathHelper.abs((double)dArray[n2]) > MathHelper.abs((double)dArray[n3]))) continue;
                n3 = n2;
            }
            double[] dArray3 = this.m_aLU[i];
            if (n3 != i) {
                int n5;
                double[] dArray4 = this.m_aLU[n3];
                for (n5 = 0; n5 < this.m_nCols; ++n5) {
                    double d = dArray4[n5];
                    dArray4[n5] = dArray3[n5];
                    dArray3[n5] = d;
                }
                n5 = this.m_aPivot[n3];
                this.m_aPivot[n3] = this.m_aPivot[i];
                this.m_aPivot[i] = n5;
                n = -n;
            }
            if (i >= this.m_nRows || dArray3[i] == 0.0) continue;
            for (int j = i + 1; j < this.m_nRows; ++j) {
                double[] dArray5 = this.m_aLU[j];
                int n6 = i;
                dArray5[n6] = dArray5[n6] / dArray3[i];
            }
        }
        this.m_nPivSign = n;
    }

    public boolean isNonsingular() {
        for (int i = 0; i < this.m_nCols; ++i) {
            if (this.m_aLU[i][i] != 0.0) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getL() {
        Matrix matrix = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aLU[i];
            double[] dArray3 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray3[j] = i > j ? dArray2[j] : (i == j ? 1.0 : 0.0);
            }
        }
        return matrix;
    }

    @Nonnull
    public Matrix getU() {
        Matrix matrix = new Matrix(this.m_nCols, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nCols; ++i) {
            double[] dArray2 = this.m_aLU[i];
            double[] dArray3 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray3[j] = i <= j ? dArray2[j] : 0.0;
            }
        }
        return matrix;
    }

    @Nonnull
    public int[] getPivot() {
        return Arrays.copyOf(this.m_aPivot, this.m_nRows);
    }

    @Nonnull
    public double[] getDoublePivot() {
        double[] dArray = new double[this.m_nRows];
        for (int i = 0; i < this.m_nRows; ++i) {
            dArray[i] = this.m_aPivot[i];
        }
        return dArray;
    }

    public double det() {
        if (this.m_nRows != this.m_nCols) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.m_nPivSign;
        for (int i = 0; i < this.m_nCols; ++i) {
            d *= this.m_aLU[i][i];
        }
        return d;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix solve(@Nonnull Matrix matrix) {
        double[] dArray;
        double[] dArray2;
        int n;
        if (matrix.getRowDimension() != this.m_nRows) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalStateException("Matrix is singular.");
        }
        int n2 = matrix.getColumnDimension();
        Matrix matrix2 = matrix.getMatrix(this.m_aPivot, 0, n2 - 1);
        double[][] dArray3 = matrix2.internalGetArray();
        for (n = 0; n < this.m_nCols; ++n) {
            dArray2 = dArray3[n];
            for (int i = n + 1; i < this.m_nCols; ++i) {
                double[] dArray4 = this.m_aLU[i];
                dArray = dArray3[i];
                for (int j = 0; j < n2; ++j) {
                    int n3 = j;
                    dArray[n3] = dArray[n3] - dArray2[j] * dArray4[n];
                }
            }
        }
        for (n = this.m_nCols - 1; n >= 0; --n) {
            dArray2 = this.m_aLU[n];
            double[] dArray5 = dArray3[n];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n4++;
                dArray5[n5] = dArray5[n5] / dArray2[n];
            }
            for (n4 = 0; n4 < n; ++n4) {
                dArray = this.m_aLU[n4];
                double[] dArray6 = dArray3[n4];
                for (int i = 0; i < n2; ++i) {
                    int n6 = i;
                    dArray6[n6] = dArray6[n6] - dArray5[i] * dArray[n];
                }
            }
        }
        return matrix2;
    }
}

