/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.mapping;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class JsonUnmappedException
extends Exception {
    private final String m_sClassName;
    private final String m_sMessage;
    private final ICommonsList<String> m_aStackTraceLines;

    public JsonUnmappedException(@NonNull String string, @Nullable String string2, @NonNull List<String> list) {
        ValueEnforcer.notNull((Object)string, (String)"ClassName");
        ValueEnforcer.notNull(list, (String)"StackTraceLines");
        this.m_sClassName = string;
        this.m_sMessage = string2;
        this.m_aStackTraceLines = new CommonsArrayList(list);
    }

    public @NonNull String getClassName() {
        return this.m_sClassName;
    }

    @Override
    public @Nullable String getMessage() {
        return this.m_sMessage;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<String> getAllStackTraceLines() {
        return (ICommonsList)this.m_aStackTraceLines.getClone();
    }

    public @Nullable IJsonObject getAsJson() {
        return (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add("class", this.m_sClassName)).addIfNotNull("message", this.m_sMessage)).add("stackTrace", StringImplode.imploder().separator("\n").source(this.m_aStackTraceLines).build());
    }
}

