/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class JsonObject
implements IJsonObject {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private ICommonsOrderedMap<String, IJson> m_aValues;

    public JsonObject() {
        this(16);
    }

    public JsonObject(@Nonnegative int n) {
        this.m_aValues = new CommonsLinkedHashMap(n);
    }

    public JsonObject(@NonNull Map<String, ? extends IJson> map) {
        ValueEnforcer.notNull(map, (String)"Jsons");
        this.m_aValues = new CommonsLinkedHashMap(map);
    }

    private void writeObject(@NonNull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_aValues.size());
        String string = this.getAsJsonString();
        StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, (String)string);
    }

    private void readObject(@NonNull ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.m_aValues = new CommonsLinkedHashMap(n);
        String string = StreamHelper.readSafeUTF((DataInput)objectInputStream);
        JsonObject jsonObject = (JsonObject)JsonReader.readFromString(string);
        if (jsonObject == null) {
            throw new IOException("Failed to parse JSON object:\n" + string);
        }
        this.m_aValues.putAll(jsonObject.m_aValues);
    }

    @Override
    public final boolean isArray() {
        return false;
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public final boolean isValue() {
        return false;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aValues.size();
    }

    public boolean isEmpty() {
        return this.m_aValues.isEmpty();
    }

    public @NonNull Iterator<Map.Entry<String, IJson>> iterator() {
        return this.m_aValues.entrySet().iterator();
    }

    public @NonNull JsonObject add(@NonNull String string, @NonNull IJson iJson) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.notNull((Object)iJson, (String)"Value");
        this.m_aValues.put((Object)string, (Object)iJson);
        return this;
    }

    @Override
    public @Nullable IJson removeKeyAndReturnValue(@Nullable String string) {
        return (IJson)this.m_aValues.remove((Object)string);
    }

    @Override
    public @NonNull EChange removeKey(@Nullable String string) {
        return this.m_aValues.removeObject((Object)string);
    }

    @Override
    public boolean containsKey(@Nullable String string) {
        return this.m_aValues.containsKey((Object)string);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> keySet() {
        return this.m_aValues.copyOfKeySet();
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<IJson> values() {
        return this.m_aValues.copyOfValues();
    }

    @Override
    public @Nullable IJson get(@Nullable String string) {
        return (IJson)this.m_aValues.get((Object)string);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<String, IJson> getAll() {
        return this.m_aValues.getClone();
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super String, ? super IJson> biConsumer) {
        this.m_aValues.forEach(biConsumer);
    }

    @Override
    public boolean containsValue(@Nullable IJson iJson) {
        return iJson != null && this.m_aValues.containsValue((Object)iJson);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<String, IJson> getClonedValues() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aValues.entrySet()) {
            commonsLinkedHashMap.put((Object)((String)entry.getKey()), (Object)((IJson)((IJson)entry.getValue()).getClone()));
        }
        return commonsLinkedHashMap;
    }

    @Override
    public @NonNull JsonObject getClone() {
        return new JsonObject((Map<String, ? extends IJson>)this.getClonedValues());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonObject jsonObject = (JsonObject)object;
        return this.m_aValues.equals(jsonObject.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).getToString();
    }
}

