/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillNotClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.json.valueserializer.IJsonValueSerializer;
import java.io.IOException;
import java.io.Writer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class JsonValueSerializerConstant
implements IJsonValueSerializer {
    public static final JsonValueSerializerConstant TRUE = new JsonValueSerializerConstant("true");
    public static final JsonValueSerializerConstant FALSE = new JsonValueSerializerConstant("false");
    public static final JsonValueSerializerConstant NULL = new JsonValueSerializerConstant("null");
    private final String m_sValue;

    public JsonValueSerializerConstant(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sValue = string;
    }

    @Nonempty
    public @NonNull String getValue() {
        return this.m_sValue;
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @WillNotClose @NonNull Writer writer) throws IOException {
        writer.write(this.m_sValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonValueSerializerConstant jsonValueSerializerConstant = (JsonValueSerializerConstant)object;
        return this.m_sValue.equals(jsonValueSerializerConstant.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Value", (Object)this.m_sValue).getToString();
    }
}

