/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHex;
import com.helger.base.system.ENewLineMode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.json.serialize.IJsonWriterSettings;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class JsonWriterSettings
implements IJsonWriterSettings {
    public static final boolean DEFAULT_INDENT_ENABLED = false;
    public static final String DEFAULT_INDENT_STRING = "  ";
    public static final String DEFAULT_NEWLINE_STRING = ENewLineMode.DEFAULT.getText();
    public static final boolean DEFAULT_WRITE_NEWLINE_AT_END = false;
    public static final boolean DEFAULT_QUOTE_NAMES = true;
    public static final IJsonWriterSettings DEFAULT_SETTINGS = new JsonWriterSettings();
    public static final IJsonWriterSettings DEFAULT_SETTINGS_FORMATTED = new JsonWriterSettings().setIndentEnabled(true);
    private boolean m_bIndentEnabled = false;
    private String m_sIndentString = "  ";
    private String m_sNewlineString = DEFAULT_NEWLINE_STRING;
    private boolean m_bWriteNewlineAtEnd = false;
    private boolean m_bQuoteNames = true;

    public JsonWriterSettings() {
    }

    public JsonWriterSettings(@NonNull IJsonWriterSettings iJsonWriterSettings) {
        ValueEnforcer.notNull((Object)iJsonWriterSettings, (String)"Other");
        this.setIndentEnabled(iJsonWriterSettings.isIdentEnabled());
        this.setIndentString(iJsonWriterSettings.getIndentString());
        this.setNewlineString(iJsonWriterSettings.getNewlineString());
        this.setWriteNewlineAtEnd(iJsonWriterSettings.isWriteNewlineAtEnd());
        this.setQuoteNames(iJsonWriterSettings.isQuoteNames());
    }

    @Override
    public boolean isIdentEnabled() {
        return this.m_bIndentEnabled;
    }

    public final @NonNull JsonWriterSettings setIndentEnabled(boolean bl) {
        this.m_bIndentEnabled = bl;
        return this;
    }

    @Override
    @Nonempty
    public @NonNull String getIndentString() {
        return this.m_sIndentString;
    }

    public final @NonNull JsonWriterSettings setIndentString(@Nonempty @NonNull String string) {
        this.m_sIndentString = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"IndentString");
        return this;
    }

    @Override
    @Nonempty
    public @NonNull String getNewlineString() {
        return this.m_sNewlineString;
    }

    public final @NonNull JsonWriterSettings setNewlineString(@Nonempty @NonNull String string) {
        this.m_sNewlineString = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"NewlineString");
        return this;
    }

    @Override
    public boolean isWriteNewlineAtEnd() {
        return this.m_bWriteNewlineAtEnd;
    }

    public final @NonNull JsonWriterSettings setWriteNewlineAtEnd(boolean bl) {
        this.m_bWriteNewlineAtEnd = bl;
        return this;
    }

    @Override
    public boolean isQuoteNames() {
        return this.m_bQuoteNames;
    }

    public final @NonNull JsonWriterSettings setQuoteNames(boolean bl) {
        this.m_bQuoteNames = bl;
        return this;
    }

    public @NonNull JsonWriterSettings getClone() {
        return new JsonWriterSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("IndentEnabled", this.m_bIndentEnabled).append("IndentString", (Object)StringHex.getHexEncoded((String)this.m_sIndentString, (Charset)StandardCharsets.ISO_8859_1)).append("NewlineString", (Object)StringHex.getHexEncoded((String)this.m_sNewlineString, (Charset)StandardCharsets.ISO_8859_1)).append("WriteNewlineAtEnd", this.m_bWriteNewlineAtEnd).append("QuoteNames", this.m_bQuoteNames).getToString();
    }
}

