/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.clone.ICloneable;
import com.helger.base.traits.IAddableByTrait;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IJson
extends ICloneable<IJson>,
IAddableByTrait {
    public boolean isArray();

    @Nullable
    default public IJsonArray getAsArray() {
        return this.isArray() ? (IJsonArray)this : null;
    }

    public boolean isObject();

    @Nullable
    default public IJsonObject getAsObject() {
        return this.isObject() ? (IJsonObject)this : null;
    }

    public boolean isValue();

    @Nullable
    default public IJsonValue getAsValue() {
        return this.isValue() ? (IJsonValue)this : null;
    }

    @Nonnull
    default public String getAsJsonString() {
        return this.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS);
    }

    @Nonnull
    default public String getAsJsonString(@Nonnull IJsonWriterSettings iJsonWriterSettings) {
        return new JsonWriter(iJsonWriterSettings).writeAsString(this);
    }
}

