/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser;

import com.helger.commons.string.ToStringGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonStringBuilder {
    protected char[] m_aBuf;
    protected int m_nLen;
    private String m_sCache;

    public JsonStringBuilder() {
        this(16);
    }

    public JsonStringBuilder(@Nonnegative int n) {
        this.m_aBuf = new char[n];
        this.m_nLen = 0;
    }

    private void _expandCapacity(@Nonnegative int n) {
        int n2 = (this.m_aBuf.length + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        this.m_aBuf = Arrays.copyOf(this.m_aBuf, n2);
    }

    public void append(char c) {
        this.m_sCache = null;
        int n = this.m_nLen + 1;
        if (n > this.m_aBuf.length) {
            this._expandCapacity(n);
        }
        this.m_aBuf[this.m_nLen++] = c;
    }

    public boolean hasContent() {
        return this.m_nLen > 0;
    }

    @Nonnegative
    public int getLength() {
        return this.m_nLen;
    }

    public char charAt(@Nonnegative int n) {
        if (n < 0 || n >= this.m_nLen) {
            throw new IllegalArgumentException("Invalid index provided: " + n + ". Allowed range is 0-" + this.m_nLen);
        }
        return this.m_aBuf[n];
    }

    @Nonnull
    public JsonStringBuilder reset() {
        this.m_nLen = 0;
        this.m_sCache = null;
        return this;
    }

    public void backup(int n) {
        this.m_nLen -= n;
    }

    @Nonnull
    public BigDecimal getAsBigDecimal() {
        return new BigDecimal(this.m_aBuf, 0, this.m_nLen);
    }

    @Nonnull
    public BigInteger getAsBigInteger() {
        return new BigInteger(this.getAsString(), 10);
    }

    @Nonnull
    public Double getAsDouble() {
        return Double.parseDouble(this.getAsString());
    }

    @Nonnull
    public String getAsString() {
        String string = this.m_sCache;
        if (string == null) {
            this.m_sCache = string = new String(this.m_aBuf, 0, this.m_nLen);
        }
        return string;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Len", this.m_nLen).append("asString", (Object)this.getAsString()).getToString();
    }
}

