/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser;

import com.helger.json.parser.IJsonParsePosition;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonParseException
extends Exception {
    private final transient IJsonParsePosition m_aTokenStart;
    private final transient IJsonParsePosition m_aErrorPos;
    private final String m_sMessage;

    public JsonParseException(@Nonnull String string) {
        super("Json parse error: " + string);
        this.m_aTokenStart = null;
        this.m_aErrorPos = null;
        this.m_sMessage = string;
    }

    public JsonParseException(@Nonnull IJsonParsePosition iJsonParsePosition, @Nonnull IJsonParsePosition iJsonParsePosition2, @Nonnull String string) {
        super("Json parse error " + iJsonParsePosition2.getAsString() + " for token starting at " + iJsonParsePosition.getAsString() + ": " + string);
        this.m_aTokenStart = iJsonParsePosition;
        this.m_aErrorPos = iJsonParsePosition2;
        this.m_sMessage = string;
    }

    @Nullable
    public final IJsonParsePosition getTokenStartPosition() {
        return this.m_aTokenStart;
    }

    @Nonnegative
    public final int getTokenStartLine() {
        return this.m_aTokenStart == null ? -1 : this.m_aTokenStart.getLineNumber();
    }

    @Nonnegative
    public final int getTokenStartColumn() {
        return this.m_aTokenStart == null ? -1 : this.m_aTokenStart.getColumnNumber();
    }

    @Nullable
    public final IJsonParsePosition getErrorPosition() {
        return this.m_aErrorPos;
    }

    @Nonnegative
    public final int getErrorLine() {
        return this.m_aErrorPos == null ? -1 : this.m_aErrorPos.getLineNumber();
    }

    @Nonnegative
    public final int getErrorColumn() {
        return this.m_aErrorPos == null ? -1 : this.m_aErrorPos.getColumnNumber();
    }

    @Nonnull
    public final String getPureMessage() {
        return this.m_sMessage;
    }
}

