/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.NonClosingOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.convert.JsonEscapeHelper;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.json.valueserializer.JsonValueSerializerEscaped;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonWriter {
    private final IJsonWriterSettings m_aSettings;

    public JsonWriter() {
        this(JsonWriterSettings.DEFAULT_SETTINGS);
    }

    public JsonWriter(@Nonnull IJsonWriterSettings iJsonWriterSettings) {
        ValueEnforcer.notNull((Object)iJsonWriterSettings, (String)"Settings");
        this.m_aSettings = (IJsonWriterSettings)iJsonWriterSettings.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IJsonWriterSettings getSettings() {
        return (IJsonWriterSettings)this.m_aSettings.getClone();
    }

    private void _writeToWriter(@Nonnull IJson iJson, @Nonnull @WillNotClose Writer writer, int n) throws IOException {
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        if (iJson.isValue()) {
            ((IJsonValue)iJson).appendAsJsonString(writer);
        } else {
            boolean bl = this.m_aSettings.isIdentEnabled() && ((IJsonCollection)iJson).isNotEmpty();
            String string = this.m_aSettings.getIndentString();
            String string2 = bl ? StringHelper.getRepeated((String)string, (int)n) : "";
            String string3 = bl ? string2 + string : "";
            String string4 = bl ? this.m_aSettings.getNewlineString() : "";
            boolean bl2 = this.m_aSettings.isQuoteNames();
            if (iJson.isArray()) {
                writer.write(91);
                if (bl) {
                    writer.write(string4);
                }
                boolean bl3 = true;
                Iterator iterator = ((IJsonArray)iJson).iterator();
                while (iterator.hasNext()) {
                    IJson iJson2 = (IJson)iterator.next();
                    if (bl3) {
                        bl3 = false;
                    } else {
                        writer.write(44);
                        if (bl) {
                            writer.write(string4);
                        }
                    }
                    if (bl) {
                        writer.write(string3);
                    }
                    this._writeToWriter(iJson2, writer, n + 1);
                }
                if (bl) {
                    writer.write(this.m_aSettings.getNewlineString());
                    writer.write(string2);
                }
                writer.write(93);
            } else {
                writer.write(123);
                if (bl) {
                    writer.write(string4);
                }
                boolean bl4 = true;
                Iterator iterator = ((IJsonObject)iJson).iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (bl4) {
                        bl4 = false;
                    } else {
                        writer.write(44);
                        if (bl) {
                            writer.write(string4);
                        }
                    }
                    if (bl) {
                        writer.write(string3);
                    }
                    if (bl2) {
                        JsonValueSerializerEscaped.appendEscapedJsonString((String)entry.getKey(), writer);
                    } else {
                        JsonEscapeHelper.jsonEscapeToWriter((String)entry.getKey(), writer);
                    }
                    writer.write(58);
                    this._writeToWriter((IJson)entry.getValue(), writer, n + 1);
                }
                if (bl) {
                    writer.write(string4);
                    writer.write(string2);
                }
                writer.write(125);
            }
        }
    }

    public void writeToWriter(@Nonnull IJson iJson, @Nonnull @WillNotClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        this._writeToWriter(iJson, writer, 0);
        if (this.m_aSettings.isWriteNewlineAtEnd()) {
            writer.write(this.m_aSettings.getNewlineString());
        }
        writer.flush();
    }

    public void writeToWriterAndClose(@Nonnull IJson iJson, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        try {
            this.writeToWriter(iJson, writer);
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    @Nonnull
    public String writeAsString(@Nonnull IJson iJson) {
        String string;
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(1024);
        try {
            this.writeToWriter(iJson, (Writer)nonBlockingStringWriter);
            string = nonBlockingStringWriter.getAsString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    nonBlockingStringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("NonBlockingStringWriter should never throw IOException!", iOException);
            }
        }
        nonBlockingStringWriter.close();
        return string;
    }

    public void writeToStream(@Nonnull IJson iJson, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull Charset charset) throws IOException {
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new NonClosingOutputStream(outputStream), charset);){
            this.writeToWriter(iJson, outputStreamWriter);
        }
    }

    public void writeToStreamAndClose(@Nonnull IJson iJson, @Nonnull @WillClose OutputStream outputStream, @Nonnull Charset charset) throws IOException {
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);){
            this.writeToWriter(iJson, outputStreamWriter);
        }
    }

    @Nonnull
    public byte[] writeAsByteArray(@Nonnull IJson iJson, @Nonnull Charset charset) {
        byte[] byArray;
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(1024);
        try {
            this.writeToStream(iJson, (OutputStream)nonBlockingByteArrayOutputStream, charset);
            byArray = nonBlockingByteArrayOutputStream.getBufferOrCopy();
        }
        catch (Throwable throwable) {
            try {
                try {
                    nonBlockingByteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("NonBlockingByteArrayOutputStream should never throw IOException!", iOException);
            }
        }
        nonBlockingByteArrayOutputStream.close();
        return byArray;
    }
}

