/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.datetime.web.PDTWebDateHelper;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalTime;
import java.time.OffsetTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterLocalTime
extends XmlAdapter<String, LocalTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterLocalTime.class);

    public LocalTime unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetTime offsetTime = PDTWebDateHelper.getOffsetTimeFromXSD((String)string2);
        if (offsetTime != null) {
            return offsetTime.toLocalTime().minusSeconds(offsetTime.getOffset().getTotalSeconds());
        }
        LocalTime localTime = PDTWebDateHelper.getLocalTimeFromXSD((String)string2);
        if (localTime == null) {
            LOGGER.warn("Failed to parse '" + string + "' to a LocalTime");
        }
        return localTime;
    }

    public String marshal(@Nullable LocalTime localTime) {
        return PDTWebDateHelper.getAsStringXSD((LocalTime)localTime);
    }
}

