/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.exception.InitializationException;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.string.StringReplace;
import com.helger.base.system.EOperatingSystem;
import com.helger.base.system.SystemHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.io.file.FileHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FilenameHelper {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char ILLEGAL_FILENAME_CHAR_REPLACEMENT = '_';
    public static final String PATH_CURRENT = ".";
    public static final String PATH_PARENT = "..";
    public static final char UNIX_SEPARATOR = '/';
    public static final String UNIX_SEPARATOR_STR = Character.toString('/');
    public static final char WINDOWS_SEPARATOR = '\\';
    public static final String WINDOWS_SEPARATOR_STR = Character.toString('\\');
    public static final String UNIX_UNC_PREFIX = "//";
    public static final String WINDOWS_UNC_PREFIX = "\\\\";
    public static final String WINDOWS_UNC_PREFIX_LOCAL1 = "\\\\.\\";
    public static final String WINDOWS_UNC_PREFIX_LOCAL2 = "\\\\?\\";
    public static final char HIDDEN_FILE_PREFIX = '.';
    private static final Logger LOGGER = LoggerFactory.getLogger(FilenameHelper.class);
    private static final char[] ILLEGAL_CHARACTERS_WINDOWS = new char[]{'\u0000', '<', '>', '?', '*', ':', '|', '\"'};
    private static final char[] ILLEGAL_CHARACTERS_OTHERS = new char[]{'\u0000', '<', '>', '?', '*', '|', '\"'};
    private static final char[] ILLEGAL_CHARACTERS = EOperatingSystem.getCurrentOS().isWindowsBased() ? ILLEGAL_CHARACTERS_WINDOWS : ILLEGAL_CHARACTERS_OTHERS;
    private static final String[] ILLEGAL_PREFIXES = new String[]{"CLOCK$", "CON", "PRN", "AUX", "NUL", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final char[] ILLEGAL_SUFFIXES = new char[]{'.', ' ', '\t'};
    private static final FilenameHelper INSTANCE;

    private FilenameHelper() {
    }

    public static int getIndexOfExtension(@Nullable String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(46);
        int n2 = FilenameHelper.getIndexOfLastSeparator(string);
        return n2 > n ? -1 : n;
    }

    public static @Nullable String getWithoutExtension(@Nullable File file) {
        return file == null ? null : FilenameHelper.getWithoutExtension(file.getPath());
    }

    public static @Nullable String getWithoutExtension(@Nullable String string) {
        int n = FilenameHelper.getIndexOfExtension(string);
        return n == -1 ? string : string.substring(0, n);
    }

    public static @NonNull String getExtension(@Nullable File file) {
        return file == null ? "" : FilenameHelper.getExtension(file.getName());
    }

    public static @NonNull String getExtension(@Nullable String string) {
        int n = FilenameHelper.getIndexOfExtension(string);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static boolean hasExtension(@Nullable File file, String ... stringArray) {
        ValueEnforcer.notNull((Object)stringArray, (String)"Extensions");
        String string = FilenameHelper.getExtension(file);
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(@Nullable String string, String ... stringArray) {
        ValueEnforcer.notNull((Object)stringArray, (String)"Extensions");
        String string2 = FilenameHelper.getExtension(string);
        for (String string3 : stringArray) {
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    public static int getIndexOfLastSeparator(@Nullable String string) {
        return string == null ? -1 : Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
    }

    public static @Nullable String getWithoutPath(@Nullable File file) {
        return file == null ? null : file.getName();
    }

    public static @Nullable String getWithoutPath(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameHelper.getIndexOfLastSeparator(string);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static @Nullable String getPath(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameHelper.getIndexOfLastSeparator(string);
        return n == -1 ? "" : string.substring(0, n + 1);
    }

    public static @Nullable String getBaseName(@Nullable File file) {
        return file == null ? null : FilenameHelper.getWithoutExtension(file.getName());
    }

    public static @Nullable String getBaseName(@Nullable String string) {
        return FilenameHelper.getWithoutExtension(FilenameHelper.getWithoutPath(string));
    }

    public static @Nullable String getPathUsingUnixSeparator(@Nullable File file) {
        return file == null ? null : FilenameHelper.getPathUsingUnixSeparator(file.getPath());
    }

    public static @Nullable String getPathUsingUnixSeparator(@Nullable String string) {
        return string == null ? null : StringReplace.replaceAll((String)string, (char)'\\', (char)'/');
    }

    public static @Nullable String getPathUsingWindowsSeparator(@Nullable File file) {
        return file == null ? null : FilenameHelper.getPathUsingWindowsSeparator(file.getPath());
    }

    public static @Nullable String getPathUsingWindowsSeparator(@Nullable String string) {
        return string == null ? null : StringReplace.replaceAll((String)string, (char)'/', (char)'\\');
    }

    public static boolean isEqualIgnoreFileSeparator(@Nullable String string, @Nullable String string2) {
        return EqualsHelper.equals((Object)FilenameHelper.getPathUsingUnixSeparator(string), (Object)FilenameHelper.getPathUsingUnixSeparator(string2));
    }

    public static @Nullable String getSecureFilename(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(0);
        return n == -1 ? string : string.substring(0, n);
    }

    public static boolean isValidFilename(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        if (FilenameHelper.containsPathSeparatorChar(string)) {
            return false;
        }
        if (StringHelper.endsWithAny((CharSequence)string, (char[])ILLEGAL_SUFFIXES)) {
            return false;
        }
        for (char c : ILLEGAL_CHARACTERS) {
            if (string.indexOf(c) == -1) continue;
            return false;
        }
        for (char c : (Object)ILLEGAL_PREFIXES) {
            if (!string.equalsIgnoreCase((String)c)) continue;
            return false;
        }
        Object object = string.toUpperCase(SystemHelper.getSystemLocale());
        for (String string2 : ILLEGAL_PREFIXES) {
            if (!((String)object).startsWith(string2 + PATH_CURRENT)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFilenameWithPaths(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        File file = new File(string);
        while (file != null) {
            String string2 = file.getName();
            File file2 = file.getParentFile();
            if (string2.length() == 0 && file2 == null) break;
            if (!FilenameHelper.isValidFilename(string2)) {
                return false;
            }
            file = file2;
        }
        return true;
    }

    public static @Nullable @Nonempty String getAsSecureValidFilename(@Nullable String string) {
        Object object = FilenameHelper.getSecureFilename(string);
        Object object2 = object;
        if (StringHelper.isNotEmpty((String)object2)) {
            String string2;
            while (((String)object).length() > 0 && StringHelper.endsWithAny((CharSequence)object, (char[])ILLEGAL_SUFFIXES)) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            for (char c : ILLEGAL_CHARACTERS) {
                object = StringReplace.replaceAll((String)object, (char)c, (char)'_');
            }
            String string3 = object;
            if (ArrayHelper.containsAny((Object[])ILLEGAL_PREFIXES, string3::equalsIgnoreCase)) {
                object = "_" + (String)object;
            }
            if (ArrayHelper.containsAny((Object[])ILLEGAL_PREFIXES, arg_0 -> FilenameHelper.lambda$getAsSecureValidFilename$0(string2 = ((String)object).toUpperCase(SystemHelper.getSystemLocale()), arg_0))) {
                object = "_" + (String)object;
            }
        }
        return StringHelper.isEmpty((String)object) ? null : object;
    }

    public static boolean isSecureFilenameCharacter(char c) {
        return c >= ' ' && c < '\u0080';
    }

    public static @Nullable @Nonempty String getAsSecureValidASCIIFilename(@Nullable String string) {
        return FilenameHelper.getAsSecureValidASCIIFilename(string, '_');
    }

    public static @Nullable @Nonempty String getAsSecureValidASCIIFilename(@Nullable String string, char c) {
        String string2 = FilenameHelper.getAsSecureValidFilename(string);
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (char c2 : string2.toCharArray()) {
            if (FilenameHelper.isSecureFilenameCharacter(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isPathSeparatorChar(char c) {
        return c == '/' || c == '\\';
    }

    public static boolean startsWithPathSeparatorChar(@Nullable CharSequence charSequence) {
        return FilenameHelper.isPathSeparatorChar(StringHelper.getFirstChar((CharSequence)charSequence));
    }

    public static boolean endsWithPathSeparatorChar(@Nullable CharSequence charSequence) {
        return FilenameHelper.isPathSeparatorChar(StringHelper.getLastChar((CharSequence)charSequence));
    }

    public static boolean containsPathSeparatorChar(@Nullable String string) {
        return string != null && (string.indexOf(47) >= 0 || string.indexOf(92) >= 0);
    }

    public static boolean isSystemInternalDirectory(@Nullable File file) {
        return file != null && FilenameHelper.isSystemInternalDirectory(file.getName());
    }

    public static boolean isSystemInternalDirectory(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        Path path2 = path.getFileName();
        return path2 != null && FilenameHelper.isSystemInternalDirectory(path2.toString());
    }

    public static boolean isSystemInternalDirectory(@Nullable CharSequence charSequence) {
        return charSequence != null && (charSequence.equals(PATH_CURRENT) || charSequence.equals(PATH_PARENT));
    }

    public static boolean isUNCPath(@NonNull File file) {
        String string = file.getAbsolutePath();
        return FilenameHelper.isUNCPath(string);
    }

    public static boolean isUNCPath(@NonNull String string) {
        return string.startsWith(WINDOWS_UNC_PREFIX) || string.startsWith(UNIX_UNC_PREFIX);
    }

    public static boolean isWindowsLocalUNCPath(@NonNull File file) {
        String string = file.getAbsolutePath();
        return FilenameHelper.isWindowsLocalUNCPath(string);
    }

    public static boolean isWindowsLocalUNCPath(@NonNull String string) {
        return string.startsWith(WINDOWS_UNC_PREFIX_LOCAL1) || string.startsWith(WINDOWS_UNC_PREFIX_LOCAL2);
    }

    public static @NonNull String getCleanPath(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        if (!FilenameHelper.isUNCPath(file)) {
            try {
                return FilenameHelper.getPathUsingUnixSeparator(FileHelper.getCanonicalPath(file));
            }
            catch (IOException iOException) {
                LOGGER.warn("Using getCleanPath on an invalid file '" + String.valueOf(file) + "' - " + iOException.getMessage());
            }
        }
        return FilenameHelper.getCleanPath(file.getAbsolutePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @Nullable String getCleanPath(@Nullable String string) {
        int n;
        if (string == null) {
            return null;
        }
        Object object = "";
        String string2 = FilenameHelper.getSecureFilename(string);
        boolean bl = false;
        if (FilenameHelper.isUNCPath(string2)) {
            object = (String)object + string2.substring(0, 2);
            string2 = string2.substring(2);
            bl = ((String)object).startsWith(WINDOWS_SEPARATOR_STR);
        }
        int n2 = string2.indexOf("://");
        boolean bl2 = false;
        if (n2 > -1) {
            var6_6 = string2.indexOf(47, n2 + 3);
            if (var6_6 < 0) return string2;
            object = (String)object + string2.substring(0, var6_6 + 1);
            string2 = string2.substring(var6_6 + 1);
            bl2 = true;
        } else {
            var6_6 = string2.indexOf(58);
            if (var6_6 >= 0) {
                object = (String)object + string2.substring(0, var6_6 + 1);
                string2 = string2.substring(var6_6 + 1);
                bl2 = true;
            }
        }
        if (StringHelper.startsWith((CharSequence)(string2 = FilenameHelper.getPathUsingUnixSeparator(string2)), (char)'/')) {
            if (((String)object).length() == 0) {
                bl2 = true;
            }
            object = (String)object + (bl ? (char)'\\' : '/');
            string2 = string2.substring(1);
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n3 = 0;
        String[] stringArray = StringHelper.getExplodedArray((char)'/', (String)string2);
        for (n = stringArray.length - 1; n >= 0; --n) {
            String string3 = stringArray[n];
            if (string3.length() == 0 || PATH_CURRENT.equals(string3)) continue;
            if (PATH_PARENT.equals(string3)) {
                ++n3;
                continue;
            }
            if (n3 > 0) {
                --n3;
                continue;
            }
            commonsArrayList.add(0, (Object)string3);
        }
        if (bl2) return (String)object + StringImplode.getImploded((char)(bl ? (char)'\\' : (char)'/'), (Collection)commonsArrayList);
        for (n = 0; n < n3; ++n) {
            commonsArrayList.add(0, (Object)PATH_PARENT);
        }
        return (String)object + StringImplode.getImploded((char)(bl ? (char)'\\' : (char)'/'), (Collection)commonsArrayList);
    }

    public static @NonNull String getCleanConcatenatedUrlPath(@NonNull String string, @NonNull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"URL");
        ValueEnforcer.notNull((Object)string2, (String)"Path");
        if (StringHelper.isEmpty((String)string2)) {
            return FilenameHelper.getCleanPath(string);
        }
        Object object = StringHelper.endsWith((CharSequence)string, (char)'/') ? string : string + "/";
        String string3 = StringHelper.startsWith((CharSequence)string2, (char)'/') ? string2.substring(1) : string2;
        return FilenameHelper.getCleanPath((String)object + string3);
    }

    @CheckReturnValue
    public static @Nullable String ensurePathStartingWithSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return FilenameHelper.startsWithPathSeparatorChar(string) ? string : File.separator + string;
    }

    @CheckReturnValue
    public static @Nullable String ensurePathEndingWithoutSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        while (FilenameHelper.endsWithPathSeparatorChar(string2)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @CheckReturnValue
    public static @Nullable String ensurePathEndingWithSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return FilenameHelper.endsWithPathSeparatorChar(string) ? string : string + File.separator;
    }

    public static @Nullable String getRelativeToParentDirectory(@NonNull File file, @Nullable File file2) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        String string = FilenameHelper.getCleanPath(file);
        if (file2 == null) {
            return string;
        }
        String string2 = StringHelper.trimStart((String)string, (String)FilenameHelper.getCleanPath(file2));
        if (string2.equals(string)) {
            return null;
        }
        if (FilenameHelper.startsWithPathSeparatorChar(string2)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static @Nullable String getAbsoluteWithEnsuredParentDirectory(@NonNull File file, @NonNull String string) {
        ValueEnforcer.notNull((Object)file, (String)"ParentDirectory");
        ValueEnforcer.notNull((Object)string, (String)"FilePath");
        File file2 = new File(string);
        String string2 = string;
        if (file2.isAbsolute()) {
            if (!file.isAbsolute()) {
                LOGGER.error("Cannot express absolute child file ('" + String.valueOf(file2) + "') relative to a relative parent file ('" + String.valueOf(file) + "')!");
                return null;
            }
            string2 = FilenameHelper.getRelativeToParentDirectory(file2, file);
        }
        if (string2 == null) {
            return null;
        }
        String string3 = FilenameHelper.getCleanPath(file);
        String string4 = FilenameHelper.getCleanPath(new File(string3, string2));
        if (!string4.startsWith(string3)) {
            return null;
        }
        return string4;
    }

    public static boolean isHiddenFilename(@Nullable File file) {
        return file != null && FilenameHelper.isHiddenFilename(file.getName());
    }

    public static boolean isHiddenFilename(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) && string.charAt(0) == '.';
    }

    private static /* synthetic */ boolean lambda$getAsSecureValidFilename$0(String string, String string2) {
        return string.startsWith(string2 + PATH_CURRENT);
    }

    static {
        if (!FilenameHelper.isSecureFilenameCharacter('_')) {
            throw new InitializationException("The illegal filename replacement character must be a valid ASCII character!");
        }
        INSTANCE = new FilenameHelper();
    }
}

