/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.codec.base64;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.base64.Base64;
import com.helger.base.codec.base64.Base64InputStream;
import com.helger.base.codec.base64.Base64OutputStream;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.state.ESuccess;
import com.helger.io.file.FileHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jspecify.annotations.NonNull;

@Immutable
public final class Base64File {
    public static @NonNull ESuccess encodeToFile(byte @NonNull [] byArray, @NonNull File file) throws IOException {
        ValueEnforcer.notNull((Object)byArray, (String)"DataToEncode");
        ValueEnforcer.notNull((Object)file, (String)"File");
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
            ESuccess eSuccess;
            if (nonBlockingBufferedOutputStream == null) {
                ESuccess eSuccess2 = ESuccess.FAILURE;
                return eSuccess2;
            }
            try (Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)nonBlockingBufferedOutputStream, 1);){
                base64OutputStream.write(byArray);
                eSuccess = ESuccess.SUCCESS;
            }
            return eSuccess;
        }
    }

    public static @NonNull ESuccess decodeToFile(@NonNull String string, @NonNull File file) throws IOException {
        ValueEnforcer.notNull((Object)string, (String)"DataToDecode");
        ValueEnforcer.notNull((Object)file, (String)"File");
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
            ESuccess eSuccess;
            if (nonBlockingBufferedOutputStream == null) {
                ESuccess eSuccess2 = ESuccess.FAILURE;
                return eSuccess2;
            }
            try (Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)nonBlockingBufferedOutputStream, 0);){
                base64OutputStream.write(string.getBytes(Base64.PREFERRED_ENCODING));
                eSuccess = ESuccess.SUCCESS;
            }
            return eSuccess;
        }
    }

    @ReturnsMutableCopy
    public static byte @NonNull [] decodeFromFile(@NonNull String string) throws IOException {
        File file = new File(string);
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException("File '" + string + "' is too big for this convenience method (" + file.length() + " bytes).");
        }
        try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = FileHelper.getBufferedInputStream(file);){
            byte[] byArray;
            if (nonBlockingBufferedInputStream == null) {
                throw new IOException("Failed to open file '" + file.getAbsolutePath() + "'");
            }
            byte[] byArray2 = new byte[(int)file.length()];
            try (Base64InputStream base64InputStream = new Base64InputStream((InputStream)nonBlockingBufferedInputStream, 0);){
                int n;
                int n2 = 0;
                while ((n = base64InputStream.read(byArray2, n2, 4096)) >= 0) {
                    n2 += n;
                }
                byte[] byArray3 = new byte[n2];
                System.arraycopy(byArray2, 0, byArray3, 0, n2);
                byArray = byArray3;
            }
            return byArray;
        }
    }

    public static @NonNull String encodeFromFile(@NonNull String string) throws IOException {
        File file = new File(string);
        long l = (long)((double)file.length() * 1.4) + 1L;
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File '" + string + "' is too big for this convenience method (" + file.length() + " bytes).");
        }
        try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = FileHelper.getBufferedInputStream(file);){
            String string2;
            if (nonBlockingBufferedInputStream == null) {
                throw new IOException("Failed to open file '" + file.getAbsolutePath() + "'");
            }
            try (Base64InputStream base64InputStream = new Base64InputStream((InputStream)nonBlockingBufferedInputStream, 1);){
                int n;
                byte[] byArray = new byte[Math.max((int)l, 40)];
                int n2 = 0;
                while ((n = base64InputStream.read(byArray, n2, 4096)) >= 0) {
                    n2 += n;
                }
                string2 = new String(byArray, 0, n2, Base64.PREFERRED_ENCODING);
            }
            return string2;
        }
    }

    public static void encodeFileToFile(@NonNull String string, @NonNull File file) throws IOException {
        String string2 = Base64File.encodeFromFile(string);
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
            nonBlockingBufferedOutputStream.write(string2.getBytes(Base64.PREFERRED_ENCODING));
        }
    }

    public static void decodeFileToFile(@NonNull String string, @NonNull File file) throws IOException {
        byte[] byArray = Base64File.decodeFromFile(string);
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
            nonBlockingBufferedOutputStream.write(byArray);
        }
    }
}

