/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resourceprovider;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class ClassPathResourceProvider
implements IReadableResourceProvider {
    private final String m_sPrefix;

    public ClassPathResourceProvider() {
        this(null);
    }

    public ClassPathResourceProvider(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nullable
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    public boolean supportsReading(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        return new ClassPathResource((String)(this.m_sPrefix == null ? string : this.m_sPrefix + string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ClassPathResourceProvider classPathResourceProvider = (ClassPathResourceProvider)object;
        return EqualsHelper.equals((Object)this.m_sPrefix, (Object)classPathResourceProvider.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("prefix", (Object)this.m_sPrefix).getToString();
    }
}

