/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.EAppend;
import com.helger.base.io.nonblocking.NonBlockingBufferedInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.nonblocking.NonBlockingBufferedWriter;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FilenameHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PathHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathHelper.class);
    private static final PathHelper INSTANCE = new PathHelper();

    private PathHelper() {
    }

    public static boolean equalPaths(@Nonnull Path path, @Nonnull Path path2) {
        try {
            return path.toRealPath(new LinkOption[0]).equals(path2.toRealPath(new LinkOption[0]));
        }
        catch (IOException iOException) {
            return path.equals(path2);
        }
    }

    public static boolean canReadAndWriteFile(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        return FileHelper.canReadAndWriteFile(path.toFile());
    }

    @Nonnull
    public static EChange ensureParentDirectoryIsPresent(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        return FileHelper.ensureParentDirectoryIsPresent(path.toFile());
    }

    @Nullable
    public static Path getCanonicalFile(@Nullable Path path) throws IOException {
        return path == null ? null : path.toRealPath(new LinkOption[0]);
    }

    @Nullable
    public static Path getCanonicalFileOrNull(@Nullable Path path) {
        if (path != null) {
            try {
                return path.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getCanonicalPath(@Nullable Path path) throws IOException {
        return path == null ? null : path.toRealPath(new LinkOption[0]).toString();
    }

    @Nullable
    public static String getCanonicalPathOrNull(@Nullable Path path) {
        if (path != null) {
            try {
                return path.toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isParentDirectory(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull((Object)path, (String)"SearchDirectory");
        ValueEnforcer.notNull((Object)path2, (String)"StartDirectory");
        Path path3 = path.toAbsolutePath();
        Path path4 = path2.toAbsolutePath();
        try {
            path3 = PathHelper.getCanonicalFile(path3);
            path4 = PathHelper.getCanonicalFile(path4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path3.toFile().isDirectory()) {
            for (Path path5 = path4; path5 != null; path5 = path5.getParent()) {
                if (!path5.equals(path3)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static NonBlockingBufferedInputStream getBufferedInputStream(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"File");
        InputStream inputStream = PathHelper.getInputStream(path);
        if (inputStream == null) {
            return null;
        }
        return new NonBlockingBufferedInputStream(inputStream);
    }

    @Nullable
    public static Reader getReader(@Nonnull Path path, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return StreamHelper.createReader((InputStream)PathHelper.getInputStream(path), (Charset)charset);
    }

    @Nullable
    public static NonBlockingBufferedReader getBufferedReader(@Nonnull Path path, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        Reader reader = PathHelper.getReader(path, charset);
        if (reader == null) {
            return null;
        }
        return new NonBlockingBufferedReader(reader);
    }

    @Nullable
    public static OutputStream getOutputStream(@Nonnull Path path) {
        return PathHelper.getOutputStream(path, EAppend.DEFAULT);
    }

    @Nullable
    public static OutputStream getOutputStream(@Nonnull Path path, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        ValueEnforcer.notNull((Object)eAppend, (String)"Append");
        try {
            return Files.newOutputStream(path, eAppend.getAsOpenOptions());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static NonBlockingBufferedOutputStream getBufferedOutputStream(@Nonnull Path path) {
        return PathHelper.getBufferedOutputStream(path, EAppend.DEFAULT);
    }

    @Nullable
    public static NonBlockingBufferedOutputStream getBufferedOutputStream(@Nonnull Path path, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull((Object)path, (String)"File");
        ValueEnforcer.notNull((Object)eAppend, (String)"Append");
        OutputStream outputStream = PathHelper.getOutputStream(path, eAppend);
        if (outputStream == null) {
            return null;
        }
        return new NonBlockingBufferedOutputStream(outputStream);
    }

    @Nullable
    public static Writer getWriter(@Nonnull Path path, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return StreamHelper.createWriter((OutputStream)PathHelper.getOutputStream(path, eAppend), (Charset)charset);
    }

    @Nullable
    public static NonBlockingBufferedWriter getBufferedWriter(@Nonnull Path path, @Nonnull EAppend eAppend, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        Writer writer = PathHelper.getWriter(path, eAppend, charset);
        if (writer == null) {
            return null;
        }
        return new NonBlockingBufferedWriter(writer);
    }

    public static boolean isFileNewer(@Nonnull Path path, @Nonnull Path path2) {
        ValueEnforcer.notNull((Object)path, (String)"File1");
        ValueEnforcer.notNull((Object)path2, (String)"aFile2");
        return FileHelper.isFileNewer(path.toFile(), path2.toFile());
    }

    @Nonnegative
    public static int getDirectoryObjectCount(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Directory");
        ValueEnforcer.isTrue((boolean)path.toFile().isDirectory(), (String)("Passed object is not a directory: " + String.valueOf(path)));
        int n = 0;
        for (Path path2 : PathHelper.getDirectoryContent(path)) {
            if (FilenameHelper.isSystemInternalDirectory(path2)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    public static Path walkFileTree(@Nonnull Path path, @Nonnegative int n, @Nonnull FileVisitor<? super Path> fileVisitor) {
        return PathHelper.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), n, fileVisitor);
    }

    @Nonnull
    public static Path walkFileTree(@Nonnull Path path, @Nonnull Set<FileVisitOption> set, @Nonnegative int n, @Nonnull FileVisitor<? super Path> fileVisitor) {
        try {
            return Files.walkFileTree(path, set, n, fileVisitor);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<Path> _getDirectoryContent(@Nonnull Path path, final @Nullable Predicate<? super Path> predicate) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        PathHelper.walkFileTree(path, 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((ICommonsList)commonsArrayList){
            final /* synthetic */ ICommonsList val$ret;
            {
                this.val$ret = iCommonsList;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (predicate == null || predicate.test(path)) {
                    this.val$ret.add((Object)path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (commonsArrayList.isEmpty()) {
            if (predicate == null) {
                File file = path.toFile();
                if (!file.isDirectory()) {
                    LOGGER.warn("Cannot list non-directory: " + String.valueOf(path.toAbsolutePath()));
                } else if (!Files.isExecutable(path)) {
                    LOGGER.warn("Existing directory is missing the listing permission: " + String.valueOf(path.toAbsolutePath()));
                } else if (!Files.isReadable(path)) {
                    LOGGER.warn("Cannot list directory because of no read-rights: " + String.valueOf(path.toAbsolutePath()));
                } else if (!file.exists()) {
                    LOGGER.warn("Cannot list non-existing: " + String.valueOf(path.toAbsolutePath()));
                }
            }
        } else if (!Files.isExecutable(path)) {
            LOGGER.warn("Directory is missing the listing permission: " + String.valueOf(path.toAbsolutePath()));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Path> getDirectoryContent(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Directory");
        return PathHelper._getDirectoryContent(path, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Path> getDirectoryContent(@Nonnull Path path, @Nullable Predicate<? super Path> predicate) {
        ValueEnforcer.notNull((Object)path, (String)"Directory");
        return PathHelper._getDirectoryContent(path, predicate);
    }

    @Nullable
    public static URL getAsURL(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Failed to convert path to URL: " + String.valueOf(path), (Throwable)malformedURLException);
            return null;
        }
    }
}

