/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.Nonempty;
import com.helger.cache.regex.RegExHelper;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FilenameHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Objects;
import java.util.function.Predicate;

@FunctionalInterface
public interface IFileFilter
extends FileFilter,
FilenameFilter,
Predicate<File> {
    @Override
    default public boolean accept(@Nullable File file) {
        return this.test(file);
    }

    @Override
    default public boolean accept(@Nullable File file, @Nullable String string) {
        if (string == null) {
            return false;
        }
        File file2 = file != null ? new File(file, string) : new File(string);
        return this.test(file2);
    }

    @Nonnull
    public static IFileFilter directoryOnly() {
        return FileHelper::existsDir;
    }

    @Nonnull
    public static IFileFilter directoryPublic() {
        return file -> FileHelper.existsDir(file) && !FilenameHelper.isHiddenFilename(file);
    }

    @Nonnull
    public static IFileFilter parentDirectoryPublic() {
        return file -> {
            File file2 = file != null ? file.getAbsoluteFile().getParentFile() : null;
            return file2 != null && !FilenameHelper.isHiddenFilename(file2);
        };
    }

    @Nonnull
    public static IFileFilter fileOnly() {
        return FileHelper::existsFile;
    }

    @Nonnull
    public static IFileFilter filenameHidden() {
        return FilenameHelper::isHiddenFilename;
    }

    @Nonnull
    public static IFileFilter filenameStartsWith(@Nonnull @Nonempty String string) {
        Objects.requireNonNull(string);
        return file -> {
            String string2;
            if (file != null && (string2 = FilenameHelper.getSecureFilename(file.getName())) != null) {
                return string2.startsWith(string);
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameEndsWith(@Nonnull @Nonempty String string) {
        Objects.requireNonNull(string);
        return file -> {
            String string2;
            if (file != null && (string2 = FilenameHelper.getSecureFilename(file.getName())) != null) {
                return string2.endsWith(string);
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameEquals(@Nonnull @Nonempty String string) {
        Objects.requireNonNull(string);
        return file -> file != null && string.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameEqualsIgnoreCase(@Nonnull @Nonempty String string) {
        Objects.requireNonNull(string);
        return file -> file != null && string.equalsIgnoreCase(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameNotEquals(@Nonnull @Nonempty String string) {
        Objects.requireNonNull(string);
        return file -> file != null && !string.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameNotEqualsIgnoreCase(@Nonnull @Nonempty String string) {
        Objects.requireNonNull(string);
        return file -> file != null && !string.equalsIgnoreCase(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameMatchAnyRegEx(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            String string;
            if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
                for (String string2 : stringArray) {
                    if (!RegExHelper.stringMatchesPattern((String)string2, (String)string)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameMatchNoRegEx(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            if (file == null) {
                return false;
            }
            String string = FilenameHelper.getSecureFilename(file.getName());
            if (string == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!RegExHelper.stringMatchesPattern((String)string2, (String)string)) continue;
                return false;
            }
            return true;
        };
    }

    @Nonnull
    public static IFileFilter filenameMatchAny(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            String string;
            if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameMatchNone(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            if (file == null) {
                return false;
            }
            String string = FilenameHelper.getSecureFilename(file.getName());
            if (string == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                return false;
            }
            return true;
        };
    }
}

