/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.AbstractQValueList;
import com.helger.http.header.QValue;
import java.util.Locale;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class AcceptEncodingList
extends AbstractQValueList<String> {
    private static @NonNull String _unify(@NonNull String string) {
        return string.toLowerCase(Locale.US);
    }

    public @NonNull AcceptEncodingList addEncoding(@NonNull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Encoding");
        this.qvalueMap().put((Object)AcceptEncodingList._unify(string), (Object)new QValue(d));
        return this;
    }

    public @NonNull QValue getQValueOfEncoding(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Encoding");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptEncodingList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfEncoding(@NonNull String string) {
        return this.getQValueOfEncoding(string).getQuality();
    }

    public boolean supportsEncoding(@NonNull String string) {
        return this.getQValueOfEncoding(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsEncoding(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Encoding");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptEncodingList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    public boolean supportsGZIP() {
        return this.supportsEncoding("gzip") || this.supportsEncoding("x-gzip");
    }

    public @Nullable String getUsedGZIPEncoding() {
        if (this.supportsEncoding("gzip")) {
            return "gzip";
        }
        if (this.supportsEncoding("x-gzip")) {
            return "x-gzip";
        }
        return null;
    }

    public boolean supportsDeflate() {
        return this.supportsEncoding("deflate");
    }

    public @Nullable String getUsedDeflateEncoding() {
        if (this.supportsEncoding("deflate")) {
            return "deflate";
        }
        return null;
    }

    public boolean supportsCompress() {
        return this.supportsEncoding("compress") || this.supportsEncoding("x-compress");
    }

    public @Nullable String getUsedCompressEncoding() {
        if (this.supportsEncoding("compress")) {
            return "compress";
        }
        if (this.supportsEncoding("x-compress")) {
            return "x-compress";
        }
        return null;
    }

    @Override
    public @NonNull String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(Function.identity());
    }
}

