/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.digestauth;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.http.RFC1945Helper;
import com.helger.url.ISimpleURL;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class DigestAuthServerBuilder {
    private String m_sRealm;
    private final ICommonsOrderedSet<String> m_aDomains = new CommonsLinkedHashSet();
    private String m_sNonce;
    private String m_sOpaque;
    private ETriState m_eStale = ETriState.UNDEFINED;
    private String m_sAlgorithm;
    private final ICommonsOrderedSet<String> m_aQOPs = new CommonsLinkedHashSet();

    public @NonNull DigestAuthServerBuilder setRealm(@NonNull String string) {
        if (!RFC1945Helper.isQuotedTextContent(string)) {
            throw new IllegalArgumentException("realm is invalid: " + string);
        }
        this.m_sRealm = string;
        return this;
    }

    public @NonNull DigestAuthServerBuilder addDomain(@NonNull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"Url");
        String string = iSimpleURL.getAsString();
        if (string.indexOf(32) >= 0) {
            throw new IllegalArgumentException("URL may not contain spaces: '" + string + "'");
        }
        this.m_aDomains.add((Object)string);
        return this;
    }

    public @NonNull DigestAuthServerBuilder setNonce(@NonNull String string) {
        if (!RFC1945Helper.isQuotedTextContent(string)) {
            throw new IllegalArgumentException("nonce is invalid: " + string);
        }
        this.m_sNonce = string;
        return this;
    }

    public @NonNull DigestAuthServerBuilder setOpaque(@NonNull String string) {
        if (!RFC1945Helper.isQuotedTextContent(string)) {
            throw new IllegalArgumentException("opaque is invalid: " + string);
        }
        this.m_sOpaque = string;
        return this;
    }

    public @NonNull DigestAuthServerBuilder setStale(@NonNull ETriState eTriState) {
        this.m_eStale = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"Stale");
        return this;
    }

    public @NonNull DigestAuthServerBuilder setAlgorithm(@NonNull String string) {
        if (!RFC1945Helper.isToken(string)) {
            throw new IllegalArgumentException("The passed algorithm is not a valid token: " + string);
        }
        this.m_sAlgorithm = string;
        return this;
    }

    public @NonNull DigestAuthServerBuilder addQOP(@NonNull String string) {
        if (!RFC1945Helper.isToken(string)) {
            throw new IllegalArgumentException("The passed qop-option is not a token: " + string);
        }
        this.m_aQOPs.add((Object)string);
        return this;
    }

    public boolean isValid() {
        return this.m_sRealm != null && this.m_sNonce != null;
    }

    public @NonNull @Nonempty String build() {
        if (!this.isValid()) {
            throw new IllegalStateException("Built Digest auth is not valid!");
        }
        StringBuilder stringBuilder = new StringBuilder("Digest");
        stringBuilder.append(" realm=").append(RFC1945Helper.getQuotedTextString(this.m_sRealm));
        if (this.m_aDomains.isNotEmpty()) {
            stringBuilder.append(", domain=").append(RFC1945Helper.getQuotedTextString(StringImplode.getImploded((char)' ', this.m_aDomains)));
        }
        stringBuilder.append(", nonce=").append(RFC1945Helper.getQuotedTextString(this.m_sNonce));
        if (this.m_sOpaque != null) {
            stringBuilder.append(", opaque=").append(RFC1945Helper.getQuotedTextString(this.m_sOpaque));
        }
        if (this.m_eStale.isDefined()) {
            stringBuilder.append(", stale=").append(this.m_eStale.isTrue() ? "true" : "false");
        }
        if (this.m_sAlgorithm != null) {
            stringBuilder.append(", algorithm=").append(this.m_sAlgorithm);
        }
        if (this.m_aQOPs.isNotEmpty()) {
            stringBuilder.append(", qop=").append(RFC1945Helper.getQuotedTextString(StringImplode.getImploded((char)',', this.m_aQOPs)));
        }
        return stringBuilder.toString();
    }
}

