/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.RFC5234Helper;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.RFC7230Helper;
import com.helger.http.header.specific.HttpForwardedHeaderHop;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HttpForwardedHeaderParser {
    public static final String HTTP_HEADER_FORWARDED = "Forwarded";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpForwardedHeaderParser.class);

    private HttpForwardedHeaderParser() {
    }

    private static void _skipWhitespace(@NonNull ParseContext parseContext) {
        char c;
        while (parseContext.hasMore() && RFC5234Helper.isWSP((int)(c = parseContext.getCurrentChar()))) {
            parseContext.advance();
        }
    }

    private static @Nullable String _parseToken(@NonNull ParseContext parseContext) {
        char c;
        int n = parseContext.m_nPos;
        while (parseContext.hasMore() && RFC7230Helper.isValidTokenChar(c = parseContext.getCurrentChar())) {
            parseContext.advance();
        }
        if (parseContext.m_nPos == n) {
            return null;
        }
        String string = new String(parseContext.m_aInput, n, parseContext.m_nPos - n);
        if (GlobalDebug.isDebugMode() && !RFC7230Helper.isValidToken(string)) {
            LOGGER.warn("Found internal inconsistency parsing '" + string + "' as an RFC 7230 token");
            return null;
        }
        return string;
    }

    private static boolean _expectChar(@NonNull ParseContext parseContext, char c) {
        if (!parseContext.hasMore() || parseContext.getCurrentChar() != c) {
            return false;
        }
        parseContext.advance();
        return true;
    }

    private static boolean _isValidEscapedChar(char c) {
        return RFC5234Helper.isWSP((int)c) || RFC5234Helper.isVChar((int)c);
    }

    private static boolean _isValidQuotedStringChar(char c) {
        return RFC5234Helper.isWSP((int)c) || RFC5234Helper.isVChar((int)c) && !RFC5234Helper.isDQuote((int)c) && !RFC7230Helper.isBackslash(c);
    }

    private static @Nullable String _parseQuotedString(@NonNull ParseContext parseContext) {
        if (!parseContext.hasMore() || !RFC5234Helper.isDQuote((int)parseContext.getCurrentChar())) {
            return null;
        }
        parseContext.advance();
        StringBuilder stringBuilder = new StringBuilder();
        while (parseContext.hasMore()) {
            char c = parseContext.getCurrentChar();
            if (RFC5234Helper.isDQuote((int)c)) {
                parseContext.advance();
                return stringBuilder.toString();
            }
            if (RFC7230Helper.isBackslash(c)) {
                parseContext.advance();
                if (!parseContext.hasMore()) {
                    LOGGER.warn("Found incomplete escape sequence in HTTP 'Forwarded' header value parsing. " + parseContext.getErrorLocationDetails());
                    return null;
                }
                char c2 = parseContext.getCurrentChar();
                if (HttpForwardedHeaderParser._isValidEscapedChar(c2)) {
                    stringBuilder.append(c2);
                    parseContext.advance();
                    continue;
                }
                LOGGER.warn("Found invalid character (" + c2 + ") in escape sequence in HTTP 'Forwarded' header value parsing. " + parseContext.getErrorLocationDetails());
                return null;
            }
            if (HttpForwardedHeaderParser._isValidQuotedStringChar(c)) {
                stringBuilder.append(c);
                parseContext.advance();
                continue;
            }
            LOGGER.warn("Found invalid character (" + c + ") in quoted string of HTTP 'Forwarded' header value parsing. " + parseContext.getErrorLocationDetails());
            return null;
        }
        return null;
    }

    private static @Nullable String _parseValue(@NonNull ParseContext parseContext) {
        if (!parseContext.hasMore()) {
            return null;
        }
        char c = parseContext.getCurrentChar();
        if (RFC5234Helper.isDQuote((int)c)) {
            return HttpForwardedHeaderParser._parseQuotedString(parseContext);
        }
        return HttpForwardedHeaderParser._parseToken(parseContext);
    }

    private static EPairParsingResult _parseOptionalPair(@NonNull ParseContext parseContext, @NonNull HttpForwardedHeaderHop httpForwardedHeaderHop) {
        HttpForwardedHeaderParser._skipWhitespace(parseContext);
        if (!parseContext.hasMore()) {
            return EPairParsingResult.EOI;
        }
        String string = HttpForwardedHeaderParser._parseToken(parseContext);
        if (string == null) {
            return EPairParsingResult.EOI;
        }
        HttpForwardedHeaderParser._skipWhitespace(parseContext);
        if (!HttpForwardedHeaderParser._expectChar(parseContext, '=')) {
            return EPairParsingResult.ERROR;
        }
        HttpForwardedHeaderParser._skipWhitespace(parseContext);
        String string2 = HttpForwardedHeaderParser._parseValue(parseContext);
        if (string2 == null) {
            return EPairParsingResult.ERROR;
        }
        HttpForwardedHeaderParser._skipWhitespace(parseContext);
        try {
            httpForwardedHeaderHop.addPair(string, string2);
            return EPairParsingResult.SUCCESS;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Failed to store HTTP 'Forwarded' pair '" + string + "' and '" + string2 + "'. Technical details: " + runtimeException.getMessage());
            return EPairParsingResult.ERROR;
        }
    }

    public static @Nullable HttpForwardedHeaderHop parseSingleHop(@Nullable String string) {
        HttpForwardedHeaderHop httpForwardedHeaderHop = new HttpForwardedHeaderHop();
        if (StringHelper.isEmpty((String)string)) {
            return httpForwardedHeaderHop;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return httpForwardedHeaderHop;
        }
        try {
            ParseContext parseContext = new ParseContext(string2);
            if (HttpForwardedHeaderParser._parseOptionalPair(parseContext, httpForwardedHeaderHop) != EPairParsingResult.SUCCESS) {
                return null;
            }
            while (parseContext.hasMore()) {
                HttpForwardedHeaderParser._skipWhitespace(parseContext);
                if (!HttpForwardedHeaderParser._expectChar(parseContext, ';')) {
                    LOGGER.warn("Expected a ';' as separator when parsing HTTP 'Forwarded' header value. " + parseContext.getErrorLocationDetails());
                    return null;
                }
                HttpForwardedHeaderParser._skipWhitespace(parseContext);
                if (HttpForwardedHeaderParser._parseOptionalPair(parseContext, httpForwardedHeaderHop) != EPairParsingResult.ERROR) continue;
                return null;
            }
            return httpForwardedHeaderHop;
        }
        catch (Exception exception) {
            LOGGER.error("Failed to parse HTTP 'Forwarded' header value '" + string2 + "'", (Throwable)exception);
            return null;
        }
    }

    private static @NonNull ICommonsList<String> _splitForwardedHops(@NonNull String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ParseContext parseContext = new ParseContext(string);
        StringBuilder stringBuilder = new StringBuilder();
        block0: while (parseContext.hasMore()) {
            char c = parseContext.getCurrentChar();
            if (c == ',') {
                String string2 = stringBuilder.toString().trim();
                if (string2.length() > 0) {
                    commonsArrayList.add((Object)string2);
                }
                stringBuilder.setLength(0);
                parseContext.advance();
                continue;
            }
            if (RFC5234Helper.isDQuote((int)c)) {
                stringBuilder.append(c);
                parseContext.advance();
                while (parseContext.hasMore()) {
                    char c2 = parseContext.getCurrentChar();
                    stringBuilder.append(c2);
                    parseContext.advance();
                    if (RFC5234Helper.isDQuote((int)c2)) continue block0;
                    if (!RFC7230Helper.isBackslash(c2) || !parseContext.hasMore()) continue;
                    char c3 = parseContext.getCurrentChar();
                    stringBuilder.append(c3);
                    parseContext.advance();
                }
                continue;
            }
            stringBuilder.append(c);
            parseContext.advance();
        }
        String string3 = stringBuilder.toString().trim();
        if (string3.length() > 0) {
            commonsArrayList.add((Object)string3);
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<HttpForwardedHeaderHop> parseMultipleHops(@Nullable String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.isEmpty((String)string)) {
            return commonsArrayList;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return commonsArrayList;
        }
        try {
            ICommonsList<String> iCommonsList = HttpForwardedHeaderParser._splitForwardedHops(string2);
            for (String string3 : iCommonsList) {
                HttpForwardedHeaderHop httpForwardedHeaderHop = HttpForwardedHeaderParser.parseSingleHop(string3);
                if (httpForwardedHeaderHop == null) {
                    LOGGER.warn("Failed to parse single hop of HTTP 'Forwarded' header value: '" + string3 + "'");
                    return null;
                }
                if (!httpForwardedHeaderHop.isNotEmpty()) continue;
                commonsArrayList.add((Object)httpForwardedHeaderHop);
            }
            return commonsArrayList;
        }
        catch (Exception exception) {
            LOGGER.error("Failed to parse HTTP 'Forwarded' header value '" + string2 + "'", (Throwable)exception);
            return null;
        }
    }

    @ReturnsMutableCopy
    public static @Nullable HttpForwardedHeaderHop parseAndGetLastHop(@Nullable String string) {
        ICommonsList<HttpForwardedHeaderHop> iCommonsList = HttpForwardedHeaderParser.parseMultipleHops(string);
        return iCommonsList == null ? null : (HttpForwardedHeaderHop)iCommonsList.getLastOrNull();
    }

    private static final class ParseContext {
        private final char[] m_aInput;
        private int m_nPos = 0;

        ParseContext(@NonNull String string) {
            this.m_aInput = string.toCharArray();
        }

        boolean hasMore() {
            return this.m_nPos < this.m_aInput.length;
        }

        char getCurrentChar() {
            return this.m_aInput[this.m_nPos];
        }

        void advance() {
            ++this.m_nPos;
        }

        @NonNull String getErrorLocationDetails() {
            char c = this.hasMore() ? this.getCurrentChar() : (char)'\u0000';
            return "The problem is at index " + this.m_nPos + " (char '" + c + "' / " + c + ") of text '" + new String(this.m_aInput) + "'";
        }
    }

    static enum EPairParsingResult {
        SUCCESS,
        ERROR,
        EOI;

    }
}

