/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.cache;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CacheControlBuilder
implements ICloneable<CacheControlBuilder> {
    private Long m_aMaxAgeSeconds;
    private Long m_aSharedMaxAgeSeconds;
    private boolean m_bPublic = false;
    private boolean m_bPrivate = false;
    private boolean m_bNoCache = false;
    private boolean m_bNoStore = false;
    private boolean m_bNoTransform = false;
    private boolean m_bMustRevalidate = false;
    private boolean m_bProxyRevalidate = false;
    private final ICommonsList<String> m_aExtensions = new CommonsArrayList();

    public CacheControlBuilder() {
    }

    public CacheControlBuilder(@NonNull CacheControlBuilder cacheControlBuilder) {
        ValueEnforcer.notNull((Object)cacheControlBuilder, (String)"Base");
        this.m_aMaxAgeSeconds = cacheControlBuilder.m_aMaxAgeSeconds;
        this.m_aSharedMaxAgeSeconds = cacheControlBuilder.m_aSharedMaxAgeSeconds;
        this.m_bPublic = cacheControlBuilder.m_bPublic;
        this.m_bPrivate = cacheControlBuilder.m_bPrivate;
        this.m_bNoCache = cacheControlBuilder.m_bNoCache;
        this.m_bNoStore = cacheControlBuilder.m_bNoStore;
        this.m_bNoTransform = cacheControlBuilder.m_bNoTransform;
        this.m_bMustRevalidate = cacheControlBuilder.m_bMustRevalidate;
        this.m_bProxyRevalidate = cacheControlBuilder.m_bProxyRevalidate;
        this.m_aExtensions.addAll(cacheControlBuilder.m_aExtensions);
    }

    public @NonNull CacheControlBuilder setMaxAge(@NonNull TimeUnit timeUnit, long l) {
        return this.setMaxAgeSeconds(timeUnit.toSeconds(l));
    }

    public @NonNull CacheControlBuilder setMaxAgeDays(@Nonnegative long l) {
        return this.setMaxAgeSeconds(l * 86400L);
    }

    public @NonNull CacheControlBuilder setMaxAgeHours(@Nonnegative long l) {
        return this.setMaxAgeSeconds(l * 3600L);
    }

    public @NonNull CacheControlBuilder setMaxAgeMinutes(@Nonnegative long l) {
        return this.setMaxAgeSeconds(l * 60L);
    }

    public @NonNull CacheControlBuilder setMaxAgeSeconds(@Nonnegative long l) {
        ValueEnforcer.isGE0((long)l, (String)"Seconds");
        this.m_aMaxAgeSeconds = l;
        return this;
    }

    public boolean hasMaxAgeSeconds() {
        return this.m_aMaxAgeSeconds != null;
    }

    public @Nullable Long getMaxAgeSeconds() {
        return this.m_aMaxAgeSeconds;
    }

    public @NonNull CacheControlBuilder setSharedMaxAge(@NonNull TimeUnit timeUnit, long l) {
        return this.setSharedMaxAgeSeconds(timeUnit.toSeconds(l));
    }

    public @NonNull CacheControlBuilder setSharedMaxAgeDays(@Nonnegative long l) {
        return this.setSharedMaxAgeSeconds(l * 86400L);
    }

    public @NonNull CacheControlBuilder setSharedMaxAgeHours(@Nonnegative long l) {
        return this.setSharedMaxAgeSeconds(l * 3600L);
    }

    public @NonNull CacheControlBuilder setSharedMaxAgeMinutes(@Nonnegative long l) {
        return this.setSharedMaxAgeSeconds(l * 60L);
    }

    public @NonNull CacheControlBuilder setSharedMaxAgeSeconds(@Nonnegative long l) {
        ValueEnforcer.isGE0((long)l, (String)"Seconds");
        this.m_aSharedMaxAgeSeconds = l;
        return this;
    }

    public boolean hasSharedMaxAgeSeconds() {
        return this.m_aSharedMaxAgeSeconds != null;
    }

    public @Nullable Long getSharedMaxAgeSeconds() {
        return this.m_aSharedMaxAgeSeconds;
    }

    public @NonNull CacheControlBuilder setPublic(boolean bl) {
        this.m_bPublic = bl;
        return this;
    }

    public boolean isPublic() {
        return this.m_bPublic;
    }

    public @NonNull CacheControlBuilder setPrivate(boolean bl) {
        this.m_bPrivate = bl;
        return this;
    }

    public boolean isPrivate() {
        return this.m_bPrivate;
    }

    public @NonNull CacheControlBuilder setNoCache(boolean bl) {
        this.m_bNoCache = bl;
        return this;
    }

    public boolean isNoCache() {
        return this.m_bNoCache;
    }

    public @NonNull CacheControlBuilder setNoStore(boolean bl) {
        this.m_bNoStore = bl;
        return this;
    }

    public boolean isNoStore() {
        return this.m_bNoStore;
    }

    public @NonNull CacheControlBuilder setNoTransform(boolean bl) {
        this.m_bNoTransform = bl;
        return this;
    }

    public boolean isNoTransform() {
        return this.m_bNoTransform;
    }

    public @NonNull CacheControlBuilder setMustRevalidate(boolean bl) {
        this.m_bMustRevalidate = bl;
        return this;
    }

    public boolean isMustRevalidate() {
        return this.m_bMustRevalidate;
    }

    public @NonNull CacheControlBuilder setProxyRevalidate(boolean bl) {
        this.m_bProxyRevalidate = bl;
        return this;
    }

    public boolean isProxyRevalidate() {
        return this.m_bProxyRevalidate;
    }

    public @NonNull CacheControlBuilder addExtension(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Extension");
        if (string.indexOf(44) >= 0) {
            throw new IllegalArgumentException("Each extension must be added separately: '" + string + "'");
        }
        this.m_aExtensions.add((Object)string);
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<String> getAllExtensions() {
        return (ICommonsList)this.m_aExtensions.getClone();
    }

    public @NonNull String getAsHTTPHeaderValue() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.m_aMaxAgeSeconds != null) {
            commonsArrayList.add((Object)("max-age=" + this.m_aMaxAgeSeconds.toString()));
        }
        if (this.m_aSharedMaxAgeSeconds != null) {
            commonsArrayList.add((Object)("s-maxage=" + this.m_aSharedMaxAgeSeconds.toString()));
        }
        if (this.m_bPublic) {
            commonsArrayList.add((Object)"public");
        }
        if (this.m_bPrivate) {
            commonsArrayList.add((Object)"private");
        }
        if (this.m_bNoCache) {
            commonsArrayList.add((Object)"no-cache");
        }
        if (this.m_bNoStore) {
            commonsArrayList.add((Object)"no-store");
        }
        if (this.m_bNoTransform) {
            commonsArrayList.add((Object)"no-transform");
        }
        if (this.m_bMustRevalidate) {
            commonsArrayList.add((Object)"must-revalidate");
        }
        if (this.m_bProxyRevalidate) {
            commonsArrayList.add((Object)"proxy-revalidate");
        }
        commonsArrayList.addAll(this.m_aExtensions);
        return StringImplode.getImploded((String)", ", (Collection)commonsArrayList);
    }

    public @NonNull CacheControlBuilder getClone() {
        return new CacheControlBuilder(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("maxAgeSecs", (Object)this.m_aMaxAgeSeconds).appendIfNotNull("sharedMaxAgeSecs", (Object)this.m_aSharedMaxAgeSeconds).append("public", this.m_bPublic).append("private", this.m_bPrivate).append("noCache", this.m_bNoCache).append("noStore", this.m_bNoStore).append("noTransform", this.m_bNoTransform).append("mustRevalidate", this.m_bMustRevalidate).append("proxyRevalidate", this.m_bProxyRevalidate).append("extensions", this.m_aExtensions).getToString();
    }
}

