/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.basicauth;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.RFC1945Helper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class BasicAuthServerBuilder {
    private String m_sRealm;

    public @Nullable String getRealm() {
        return this.m_sRealm;
    }

    public @NonNull BasicAuthServerBuilder setRealm(@NonNull String string) {
        ValueEnforcer.isTrue((boolean)RFC1945Helper.isQuotedTextContent(string), () -> "Realm is invalid: " + string);
        this.m_sRealm = string;
        return this;
    }

    public boolean isValid() {
        return this.m_sRealm != null;
    }

    @Nonempty
    public @NonNull String build() {
        if (!this.isValid()) {
            throw new IllegalStateException("Built Basic auth is not valid!");
        }
        StringBuilder stringBuilder = new StringBuilder("Basic");
        if (this.m_sRealm != null) {
            stringBuilder.append(" realm=").append(RFC1945Helper.getQuotedTextString(this.m_sRealm));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Realm", (Object)this.m_sRealm).getToString();
    }
}

