/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EHttpMethod implements IHasName
{
    OPTIONS("OPTIONS"),
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    CONNECT("CONNECT"),
    PATCH("PATCH");

    private final String m_sName;

    private EHttpMethod(String string2) {
        this.m_sName = string2;
    }

    @Nonempty
    public @NonNull String getName() {
        return this.m_sName;
    }

    public boolean isIdempodent() {
        return this == GET || this == HEAD || this == PUT || this == DELETE || this == OPTIONS || this == TRACE;
    }

    public boolean isContentAllowed() {
        return this != HEAD;
    }

    public boolean isPayloadInBody() {
        return this == POST || this == PUT || this == PATCH;
    }

    public static @Nullable EHttpMethod getFromNameOrNull(@Nullable String string) {
        return (EHttpMethod)EnumHelper.getFromNameOrNull(EHttpMethod.class, (String)string);
    }

    public static @Nullable EHttpMethod getFromNameOrDefault(@Nullable String string, @Nullable EHttpMethod eHttpMethod) {
        return (EHttpMethod)EnumHelper.getFromNameOrDefault(EHttpMethod.class, (String)string, (Enum)eHttpMethod);
    }
}

