/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.http.header.specific.AcceptEncodingList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AcceptEncodingHandler {
    public static final String ANY_ENCODING = "*";
    public static final String IDENTITY_ENCODING = "identity";
    public static final String GZIP_ENCODING = "gzip";
    public static final String X_GZIP_ENCODING = "x-gzip";
    public static final String DEFLATE_ENCODING = "deflate";
    public static final String COMPRESS_ENCODING = "compress";
    public static final String X_COMPRESS_ENCODING = "x-compress";
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptEncodingHandler.class);
    private static final AcceptEncodingHandler INSTANCE = new AcceptEncodingHandler();

    private AcceptEncodingHandler() {
    }

    @Nonnull
    public static AcceptEncodingList getAcceptEncodings(@Nullable String string) {
        AcceptEncodingList acceptEncodingList = new AcceptEncodingList();
        if (StringHelper.isEmpty((String)string)) {
            acceptEncodingList.addEncoding(IDENTITY_ENCODING, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded((char)',', (String)string)) {
                String string3;
                String[] stringArray = StringHelper.getExplodedArray((char)';', (String)string2.trim(), (int)2);
                String string4 = stringArray[0];
                if (StringHelper.isEmpty((String)string4)) {
                    LOGGER.warn("Accept-Encoding item '" + string2 + "' has no encoding!");
                    continue;
                }
                double d = 1.0;
                if (stringArray.length == 2 && (string3 = stringArray[1].trim()).startsWith("q=")) {
                    d = StringParser.parseDouble((String)string3.substring(2), (double)1.0);
                }
                acceptEncodingList.addEncoding(string4, d);
            }
        }
        return acceptEncodingList;
    }
}

