/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.AbstractQValueList;
import com.helger.http.header.QValue;
import com.helger.http.header.specific.AcceptCharsetHandler;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.function.Function;

public class AcceptCharsetList
extends AbstractQValueList<String> {
    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    @Nonnull
    public AcceptCharsetList addCharset(@Nonnull Charset charset, @Nonnegative double d) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return this.addCharset(charset.name(), d);
    }

    @Nonnull
    public AcceptCharsetList addCharset(@Nonnull @Nonempty String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Charset");
        this.qvalueMap().put((Object)AcceptCharsetList._unify(string), (Object)new QValue(d));
        return this;
    }

    @Nonnull
    public QValue getQValueOfCharset(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Charset");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptCharsetList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return string.equals(AcceptCharsetHandler.DEFAULT_CHARSET) ? QValue.MAX_QVALUE : QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfCharset(@Nonnull String string) {
        return this.getQValueOfCharset(string).getQuality();
    }

    public boolean supportsCharset(@Nonnull String string) {
        return this.getQValueOfCharset(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsCharset(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Charset");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptCharsetList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    @Override
    @Nonnull
    public String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(Function.identity());
    }
}

