/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EHttpMethod implements IHasName
{
    OPTIONS("OPTIONS"),
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    CONNECT("CONNECT"),
    PATCH("PATCH");

    private final String m_sName;

    private EHttpMethod(String string2) {
        this.m_sName = string2;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public boolean isIdempodent() {
        return this == GET || this == HEAD || this == PUT || this == DELETE || this == OPTIONS || this == TRACE;
    }

    public boolean isContentAllowed() {
        return this != HEAD;
    }

    public boolean isPayloadInBody() {
        return this == POST || this == PUT || this == PATCH;
    }

    @Nullable
    public static EHttpMethod getFromNameOrNull(@Nullable String string) {
        return (EHttpMethod)EnumHelper.getFromNameOrNull(EHttpMethod.class, (String)string);
    }

    @Nullable
    public static EHttpMethod getFromNameOrDefault(@Nullable String string, @Nullable EHttpMethod eHttpMethod) {
        return (EHttpMethod)EnumHelper.getFromNameOrDefault(EHttpMethod.class, (String)string, (Enum)eHttpMethod);
    }
}

