/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.iterate;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.IMutableDirectedGraphRelation;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class DirectedGraphIteratorBackward
implements ICommonsIterableIterator<IMutableDirectedGraphNode> {
    private final NonBlockingStack<IterationNode> m_aNodeStack = new NonBlockingStack();
    private final Predicate<? super IMutableDirectedGraphRelation> m_aRelationFilter;
    private final ICommonsSet<String> m_aHandledNodes = new CommonsHashSet();
    private boolean m_bHasCycles = false;

    public DirectedGraphIteratorBackward(@NonNull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        this(iMutableDirectedGraphNode, null);
    }

    public DirectedGraphIteratorBackward(@NonNull IMutableDirectedGraphNode iMutableDirectedGraphNode, @Nullable Predicate<? super IMutableDirectedGraphRelation> predicate) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"StartNode");
        this.m_aRelationFilter = predicate;
        this.m_aNodeStack.push((Object)new IterationNode(iMutableDirectedGraphNode));
    }

    public boolean hasNext() {
        return !this.m_aNodeStack.isEmpty();
    }

    public @Nullable IMutableDirectedGraphNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IMutableDirectedGraphNode iMutableDirectedGraphNode = ((IterationNode)this.m_aNodeStack.peek()).getNode();
        this.m_aHandledNodes.add((Object)((String)iMutableDirectedGraphNode.getID()));
        boolean bl = false;
        while (!this.m_aNodeStack.isEmpty() && !bl) {
            Iterator<IMutableDirectedGraphRelation> iterator = ((IterationNode)this.m_aNodeStack.peek()).getIncomingRelationIterator();
            while (iterator.hasNext()) {
                IMutableDirectedGraphRelation iMutableDirectedGraphRelation = iterator.next();
                if (this.m_aRelationFilter != null && !this.m_aRelationFilter.test(iMutableDirectedGraphRelation)) continue;
                IMutableDirectedGraphNode iMutableDirectedGraphNode2 = (IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getFrom();
                for (IterationNode iterationNode : this.m_aNodeStack) {
                    if (iterationNode.getNode() != iMutableDirectedGraphNode2) continue;
                    this.m_bHasCycles = true;
                    break;
                }
                if (this.m_aHandledNodes.contains(iMutableDirectedGraphNode2.getID())) continue;
                this.m_aNodeStack.push((Object)new IterationNode(iMutableDirectedGraphNode2));
                bl = true;
                break;
            }
            if (bl) continue;
            this.m_aNodeStack.pop();
        }
        return iMutableDirectedGraphNode;
    }

    public boolean hasCycles() {
        return this.m_bHasCycles;
    }

    private static final class IterationNode {
        private final IMutableDirectedGraphNode m_aNode;
        private final Iterator<IMutableDirectedGraphRelation> m_aIncomingIt;

        private IterationNode(@NonNull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
            this.m_aNode = (IMutableDirectedGraphNode)ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"Node");
            this.m_aIncomingIt = iMutableDirectedGraphNode.getAllIncomingRelations().iterator();
        }

        public @NonNull IMutableDirectedGraphNode getNode() {
            return this.m_aNode;
        }

        public @NonNull Iterator<IMutableDirectedGraphRelation> getIncomingRelationIterator() {
            return this.m_aIncomingIt;
        }
    }
}

