/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.algo;

import com.helger.annotation.Nonempty;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.graph.IMutableGraphNode;
import com.helger.graph.IMutableGraphRelation;
import com.helger.graph.simple.ISimpleGraph;
import com.helger.graph.simple.SimpleGraph;
import com.helger.graph.simple.SimpleGraphObjectFastFactory;
import java.util.Collection;
import java.util.Comparator;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Kruskal {
    private static final Logger LOGGER = LoggerFactory.getLogger(Kruskal.class);
    private static final Kruskal INSTANCE = new Kruskal();

    private Kruskal() {
    }

    private static String _getWeightInfo(@NonNull IMutableGraphRelation iMutableGraphRelation, @Nonempty @NonNull String string) {
        return "{" + StringImplode.getImploded((char)',', (Collection)new CommonsTreeSet(iMutableGraphRelation.getAllConnectedNodeIDs())) + ":" + iMutableGraphRelation.attrs().getAsInt((Object)string) + "}";
    }

    public static @NonNull Result applyKruskal(@NonNull ISimpleGraph iSimpleGraph, @Nonempty @NonNull String string) {
        ICommonsList iCommonsList = iSimpleGraph.getAllRelationObjs().getSortedInline(Comparator.comparingInt(iMutableGraphRelation -> iMutableGraphRelation.attrs().getAsInt((Object)string)));
        if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Starting Kruskal on " + iCommonsList.size() + " relations");
            LOGGER.info("Sorted relations: " + StringImplode.getImplodedMapped((char)';', (Collection)iCommonsList, iMutableGraphRelation -> Kruskal._getWeightInfo(iMutableGraphRelation, string)));
        }
        SimpleGraph simpleGraph = new SimpleGraph(new SimpleGraphObjectFastFactory());
        for (IMutableGraphNode iMutableGraphNode : iSimpleGraph.getAllNodes().values()) {
            IMutableGraphNode iMutableGraphNode2 = simpleGraph.createNode((String)iMutableGraphNode.getID());
            iMutableGraphNode2.attrs().putAllIn(iMutableGraphNode.attrs());
        }
        int n = iSimpleGraph.getNodeCount() - 1;
        int n2 = 0;
        for (IMutableGraphRelation iMutableGraphRelation2 : iCommonsList) {
            int n3 = iMutableGraphRelation2.attrs().getAsInt((Object)string);
            IMutableGraphRelation iMutableGraphRelation3 = simpleGraph.createRelation(iMutableGraphRelation2.getNode1ID(), iMutableGraphRelation2.getNode2ID());
            iMutableGraphRelation3.attrs().putAllIn(iMutableGraphRelation2.attrs());
            if (simpleGraph.containsCycles()) {
                if (GlobalDebug.isDebugMode()) {
                    LOGGER.info("Ignoring " + Kruskal._getWeightInfo(iMutableGraphRelation3, string) + " because it introduces a cycle!");
                }
                simpleGraph.removeRelation(iMutableGraphRelation3);
                continue;
            }
            if (GlobalDebug.isDebugMode()) {
                LOGGER.info("Added " + Kruskal._getWeightInfo(iMutableGraphRelation3, string) + "!");
            }
            n2 += n3;
            if (--n != 0) continue;
            break;
        }
        if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Having a total weight of " + n2);
        }
        return new Result(simpleGraph, n2);
    }

    public static final class Result {
        private final SimpleGraph m_aGraph;
        private final int m_nTotalWeight;

        public Result(@NonNull SimpleGraph simpleGraph, int n) {
            ValueEnforcer.notNull((Object)simpleGraph, (String)"Graph");
            this.m_aGraph = simpleGraph;
            this.m_nTotalWeight = n;
        }

        public @NonNull SimpleGraph getGraph() {
            return this.m_aGraph;
        }

        public int getTotalWeight() {
            return this.m_nTotalWeight;
        }

        @Nonempty
        public @NonNull String getAsString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Total weight ").append(this.m_nTotalWeight).append(" for nodes {");
            int n = 0;
            for (IMutableGraphNode iMutableGraphNode : this.m_aGraph.getAllNodes().values()) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\'').append((String)iMutableGraphNode.getID()).append('\'');
                ++n;
            }
            return stringBuilder.append('}').toString();
        }
    }
}

