/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.graph.IBaseGraphNode;
import com.helger.graph.IDirectedGraphRelation;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IDirectedGraphNode<NODETYPE extends IDirectedGraphNode<NODETYPE, RELATIONTYPE>, RELATIONTYPE extends IDirectedGraphRelation<NODETYPE, RELATIONTYPE>>
extends IBaseGraphNode<NODETYPE, RELATIONTYPE> {
    public boolean hasIncomingRelations();

    @Nonnegative
    public int getIncomingRelationCount();

    public boolean isIncomingRelation(@Nullable RELATIONTYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<RELATIONTYPE> getAllIncomingRelations();

    public void forEachIncomingRelation(@Nonnull Consumer<? super RELATIONTYPE> var1);

    public boolean isFromNode(@Nullable NODETYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<NODETYPE> getAllFromNodes();

    @Nullable
    public RELATIONTYPE getIncomingRelationFrom(@Nullable NODETYPE var1);

    public boolean hasOutgoingRelations();

    @Nonnegative
    public int getOutgoingRelationCount();

    public boolean isOutgoingRelation(@Nullable RELATIONTYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<RELATIONTYPE> getAllOutgoingRelations();

    public void forEachOutgoingRelation(@Nonnull Consumer<? super RELATIONTYPE> var1);

    public boolean isToNode(@Nullable NODETYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<NODETYPE> getAllToNodes();

    @Nullable
    public RELATIONTYPE getOutgoingRelationTo(@Nullable NODETYPE var1);

    default public boolean hasIncomingOrOutgoingRelations() {
        return this.hasIncomingRelations() || this.hasOutgoingRelations();
    }

    default public boolean hasIncomingAndOutgoingRelations() {
        return this.hasIncomingRelations() && this.hasOutgoingRelations();
    }

    @Override
    default public boolean hasRelations() {
        return this.hasIncomingOrOutgoingRelations();
    }

    @Override
    @Nonnegative
    default public int getRelationCount() {
        return this.getIncomingRelationCount() + this.getOutgoingRelationCount();
    }

    @Override
    default public void forEachRelation(@Nonnull Consumer<? super RELATIONTYPE> consumer) {
        this.forEachIncomingRelation(consumer);
        this.forEachOutgoingRelation(consumer);
    }
}

