/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.IMutableDirectedGraphRelation;
import com.helger.graph.impl.AbstractBaseGraphObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DirectedGraphRelation
extends AbstractBaseGraphObject
implements IMutableDirectedGraphRelation {
    private final IMutableDirectedGraphNode m_aFrom;
    private final IMutableDirectedGraphNode m_aTo;

    public DirectedGraphRelation(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode, @Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode2) {
        this(null, iMutableDirectedGraphNode, iMutableDirectedGraphNode2);
    }

    public DirectedGraphRelation(@Nullable String string, @Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode, @Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode2) {
        super(string);
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"From");
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode2, (String)"To");
        this.m_aFrom = iMutableDirectedGraphNode;
        this.m_aTo = iMutableDirectedGraphNode2;
    }

    @Override
    public final boolean isDirected() {
        return true;
    }

    @Override
    public boolean isRelatedTo(@Nullable IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        return this.m_aFrom.equals(iMutableDirectedGraphNode) || this.m_aTo.equals(iMutableDirectedGraphNode);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMutableDirectedGraphNode> getAllConnectedNodes() {
        return new CommonsLinkedHashSet((Object[])new IMutableDirectedGraphNode[]{this.m_aFrom, this.m_aTo});
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllConnectedNodeIDs() {
        return new CommonsLinkedHashSet((Object[])new String[]{(String)this.m_aFrom.getID(), (String)this.m_aTo.getID()});
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphNode getFrom() {
        return this.m_aFrom;
    }

    @Override
    @Nonnull
    public String getFromID() {
        return (String)this.m_aFrom.getID();
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphNode getTo() {
        return this.m_aTo;
    }

    @Override
    @Nonnull
    public String getToID() {
        return (String)this.m_aTo.getID();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DirectedGraphRelation directedGraphRelation = (DirectedGraphRelation)object;
        return this.m_aFrom.equals(directedGraphRelation.m_aFrom) && this.m_aTo.equals(directedGraphRelation.m_aTo);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aFrom).append((Object)this.m_aTo).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("from", (Object)this.m_aFrom).append("to", (Object)this.m_aTo).getToString();
    }
}

