/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.log;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.iface.IHasSize;
import com.helger.base.state.EChange;
import com.helger.base.state.IClearable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevels;
import com.helger.diagnostics.log.LogMessage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Iterator;

@NotThreadSafe
public class InMemoryLogger
implements IHasErrorLevels<LogMessage>,
IHasSize,
IClearable {
    private final ICommonsList<LogMessage> m_aMessages = new CommonsArrayList();

    @Nonnull
    @OverrideOnDemand
    protected LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now(Clock.systemDefaultZone());
    }

    @Nullable
    @OverrideOnDemand
    protected LogMessage createLogMessage(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        return new LogMessage(this.getCurrentLocalDateTime(), iErrorLevel, serializable, throwable);
    }

    @OverrideOnDemand
    protected void onAddLogMessage(@Nonnull LogMessage logMessage) {
    }

    public void log(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable) {
        this.log(iErrorLevel, serializable, null);
    }

    public void log(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        LogMessage logMessage = this.createLogMessage(iErrorLevel, serializable, throwable);
        if (logMessage != null) {
            this.m_aMessages.add((Object)logMessage);
            this.onAddLogMessage(logMessage);
        }
    }

    public void error(@Nonnull Serializable serializable) {
        this.error(serializable, null);
    }

    public void error(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.ERROR, serializable, throwable);
    }

    public void warn(@Nonnull Serializable serializable) {
        this.warn(serializable, null);
    }

    public void warn(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.WARN, serializable, throwable);
    }

    public void info(@Nonnull Serializable serializable) {
        this.log(EErrorLevel.INFO, serializable, null);
    }

    public void info(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.INFO, serializable, throwable);
    }

    public void success(@Nonnull Serializable serializable) {
        this.log(EErrorLevel.SUCCESS, serializable, null);
    }

    public void success(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.SUCCESS, serializable, throwable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<LogMessage> getAllMessages() {
        return (ICommonsList)this.m_aMessages.getClone();
    }

    @Nonnull
    public Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Nonnegative
    public int size() {
        return this.m_aMessages.size();
    }

    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aMessages.removeAll();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("messages", this.m_aMessages).getToString();
    }
}

